/**
 * $Id: ListParameter.java 131406 2012-07-24 19:21:30Z fpina $
 */
package tecgraf.openbus.algorithmservice.v1_1.parameters;

import tecgraf.openbus.algorithmservice.v1_1.ConversionToTextException;
import tecgraf.openbus.algorithmservice.v1_1.IParameterValue;

/**
 * Classe auxiliar com mtodos para manipular listas
 * 
 * @author Tecgraf
 */
public class ListParameter {

  /**
   * Caractere que define o incio de uma lista.
   */
  private static final char START_LINE_CHAR = '{';

  /**
   * Caractere que separa os elementos da lista.
   */
  private static final char ELEMENT_SEPARATOR_CHAR = ',';

  /**
   * Caractere que define o fim de uma lista.
   */
  private static final char END_LINE_CHAR = '}';

  /**
   * Converte uma lista de objetos que implementam a interface
   * {@link IParameterValue} na sua representao textual.
   * 
   * @param value lista de objetos para converter
   * 
   * @return representao textual da lista
   * @throws ConversionToTextException caso ocorra erro na convero
   */
  public static String convertListToText(IParameterValue[] value)
    throws ConversionToTextException {
    if (value == null || value.length == 0) {
      return null;
    }
    StringBuffer buffer = new StringBuffer();
    buffer.append(START_LINE_CHAR);
    String separator = "";
    for (int i = 0; i < value.length; i++) {
      buffer.append(separator);
      buffer.append(value[i].convertToText());
      separator = Character.toString(ELEMENT_SEPARATOR_CHAR);
    }
    buffer.append(END_LINE_CHAR);
    return buffer.toString();
  }
}
