/**
 * $Id: TextParameterImpl.java 131406 2012-07-24 19:21:30Z fpina $
 */
package tecgraf.openbus.algorithmservice.v1_1.parameters;

/**
 * A classe <code>TextParameterImpl</code> implementa um valutype
 * <code>TextParameter</code>
 * 
 * @author Tecgraf
 */
public class TextParameterImpl extends TextParameter {

  /**
   * Construtor padro.
   */
  public TextParameterImpl() {
    this.value = "";
  }

  /**
   * Construtor que recebe o valor do parmetro.
   * 
   * @param value valor do parmetro
   */
  public TextParameterImpl(String value) {
    this.value = value.trim();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String convertToText() {
    return value;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String getIDLType() {
    return TextParameterHelper.id();
  }
}