/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.algorithmservice.v1_1;

import java.util.HashMap;
import java.util.Vector;
import tecgraf.openbus.algorithmservice.v1_1.AlgorithmIdDoesNotExistsInFlowException;
import tecgraf.openbus.algorithmservice.v1_1.AlgorithmType;
import tecgraf.openbus.algorithmservice.v1_1.ConversionToTextException;
import tecgraf.openbus.algorithmservice.v1_1.FlowConfigurator;
import tecgraf.openbus.algorithmservice.v1_1.FlowNode;
import tecgraf.openbus.algorithmservice.v1_1.IParameterValue;
import tecgraf.openbus.algorithmservice.v1_1.IncorrectParamTypeException;
import tecgraf.openbus.algorithmservice.v1_1.InvalidParameterException;
import tecgraf.openbus.algorithmservice.v1_1.Parameter;
import tecgraf.openbus.algorithmservice.v1_1.ParameterDoesNotExistsException;
import tecgraf.openbus.algorithmservice.v1_1.SimpleConfigurator;
import tecgraf.opendreams.commontypes.v1_0.Property;

public class FlowConfiguratorImpl
extends FlowConfigurator {
    private static final String ID_SEPARATOR = ".";
    private HashMap<Integer, FlowNode> algorithmsIdMap = null;

    public FlowConfiguratorImpl() {
        this.algorithmName = "";
        this.algorithmVersion = "";
        this.type = AlgorithmType.FLOW;
        this.algorithms = new FlowNode[0];
    }

    @Override
    public void setParameterValueById(int algorithmId, String parameterName, IParameterValue value) throws AlgorithmIdDoesNotExistsInFlowException, ParameterDoesNotExistsException, IncorrectParamTypeException, java.security.InvalidParameterException {
        SimpleConfigurator sConfig = this.findAlgoConfigById(algorithmId);
        try {
            sConfig.setParameterValue(parameterName, value);
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setParameterValueAsTextById(int algorithmId, String parameterName, String valueAsText) throws ParameterDoesNotExistsException, AlgorithmIdDoesNotExistsInFlowException {
        SimpleConfigurator sConfig = this.findAlgoConfigById(algorithmId);
        sConfig.setParameterValueAsText(parameterName, valueAsText);
    }

    private SimpleConfigurator findAlgoConfigById(int id) throws AlgorithmIdDoesNotExistsInFlowException {
        if (this.algorithmsIdMap == null) {
            this.buildNodeIdMap();
        }
        if (!this.algorithmsIdMap.containsKey(id)) {
            throw new AlgorithmIdDoesNotExistsInFlowException();
        }
        FlowNode node = this.algorithmsIdMap.get(id);
        return (SimpleConfigurator)SimpleConfigurator.class.cast(node.config);
    }

    private void buildNodeIdMap() {
        this.algorithmsIdMap = new HashMap(this.algorithms.length);
        for (FlowNode node : this.algorithms) {
            this.algorithmsIdMap.put(node.id, node);
        }
    }

    @Override
    public Property[] getParameters() throws ConversionToTextException {
        Vector<Property> paramVector = new Vector<Property>();
        for (Integer id : this.algorithmsIdMap.keySet()) {
            FlowNode node = this.algorithmsIdMap.get(id);
            SimpleConfigurator algoConfig = (SimpleConfigurator)SimpleConfigurator.class.cast(node.config);
            for (int i = 0; i < algoConfig.parameters.length; ++i) {
                Parameter param = algoConfig.parameters[i];
                if (param.value == null) continue;
                paramVector.add(new Property(id + ID_SEPARATOR + param.name, param.value.convertToText()));
            }
        }
        Property[] dictionary = new Property[paramVector.size()];
        return paramVector.toArray(dictionary);
    }

    @Override
    public String[] getAlgoritmInfo() {
        return new String[]{"-name", this.algorithmName, "-version", this.algorithmVersion};
    }
}

