/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.algorithmservice.v1_1;

import java.util.HashMap;
import java.util.Vector;
import tecgraf.openbus.algorithmservice.v1_1.AlgorithmType;
import tecgraf.openbus.algorithmservice.v1_1.ConversionToTextException;
import tecgraf.openbus.algorithmservice.v1_1.IParameterValue;
import tecgraf.openbus.algorithmservice.v1_1.IncorrectParamTypeException;
import tecgraf.openbus.algorithmservice.v1_1.InvalidParameterException;
import tecgraf.openbus.algorithmservice.v1_1.Parameter;
import tecgraf.openbus.algorithmservice.v1_1.ParameterDoesNotExistsException;
import tecgraf.openbus.algorithmservice.v1_1.SimpleConfigurator;
import tecgraf.openbus.algorithmservice.v1_1.parameters.EnumerationListParameter;
import tecgraf.openbus.algorithmservice.v1_1.parameters.EnumerationListParameterImpl;
import tecgraf.openbus.algorithmservice.v1_1.parameters.EnumerationParameter;
import tecgraf.openbus.algorithmservice.v1_1.parameters.EnumerationParameterImpl;
import tecgraf.openbus.algorithmservice.v1_1.parameters.RawValueParameterHelper;
import tecgraf.openbus.algorithmservice.v1_1.parameters.RawValueParameterImpl;
import tecgraf.opendreams.commontypes.v1_0.Property;

public class SimpleConfiguratorImpl
extends SimpleConfigurator {
    HashMap<String, Parameter> parametersMap = null;

    public SimpleConfiguratorImpl() {
        this.algorithmName = "";
        this.algorithmVersion = "";
        this.type = AlgorithmType.ALGORITHM;
        this.parameters = new Parameter[0];
    }

    @Override
    public void setParameterValue(String name, IParameterValue value) throws ParameterDoesNotExistsException, IncorrectParamTypeException, InvalidParameterException {
        Parameter param;
        if (this.parametersMap == null) {
            this.buildParameterMap();
        }
        if ((param = this.parametersMap.get(name)) == null) {
            throw new ParameterDoesNotExistsException();
        }
        String valueType = value.getIDLType();
        if (!param.type.equals(valueType)) {
            throw new IncorrectParamTypeException();
        }
        if (EnumerationParameter.class.isInstance(param.value)) {
            ((EnumerationParameterImpl)EnumerationParameterImpl.class.cast(param.value)).setSelectedItem(((EnumerationParameterImpl)EnumerationParameterImpl.class.cast((Object)value)).selectedId);
        } else if (EnumerationListParameter.class.isInstance(param.value)) {
            System.out.println(param.value);
            System.out.println(value);
            ((EnumerationListParameterImpl)EnumerationListParameterImpl.class.cast(param.value)).setSelectedItems(((EnumerationListParameterImpl)EnumerationListParameterImpl.class.cast((Object)value)).selectedIds);
        } else {
            param.value = value;
        }
    }

    @Override
    public void setParameterValueAsText(String name, String valueAsText) throws ParameterDoesNotExistsException {
        Parameter param;
        if (this.parametersMap == null) {
            this.buildParameterMap();
        }
        if ((param = this.parametersMap.get(name)) == null) {
            throw new ParameterDoesNotExistsException();
        }
        param.value = new RawValueParameterImpl(valueAsText);
        param.type = RawValueParameterHelper.id();
    }

    private void buildParameterMap() {
        this.parametersMap = new HashMap(this.parameters.length);
        for (Parameter param : this.parameters) {
            this.parametersMap.put(param.name, param);
        }
    }

    @Override
    public Property[] getParameters() throws ConversionToTextException {
        Vector<Property> paramVector = new Vector<Property>();
        if (this.parametersMap == null) {
            this.buildParameterMap();
        }
        for (Parameter param : this.parametersMap.values()) {
            if (param.value == null) continue;
            paramVector.add(new Property(param.name, param.value.convertToText()));
        }
        Property[] dictionary = new Property[paramVector.size()];
        return paramVector.toArray(dictionary);
    }

    @Override
    public String[] getAlgoritmInfo() {
        return new String[]{"-name", this.algorithmName, "-version", this.algorithmVersion};
    }
}

