/*
 * Decompiled with CFR 0.152.
 */
package tecgraf.openbus.algorithmservice.v1_1.parameters;

import java.security.InvalidParameterException;
import java.util.Vector;
import tecgraf.openbus.algorithmservice.v1_1.parameters.EnumerationItem;
import tecgraf.openbus.algorithmservice.v1_1.parameters.EnumerationListParameter;
import tecgraf.openbus.algorithmservice.v1_1.parameters.EnumerationListParameterHelper;

public class EnumerationListParameterImpl
extends EnumerationListParameter {
    private Vector<EnumerationItem> vectorItems = new Vector();
    private static final char START_LINE_CHAR = '{';
    private static final char END_LINE_CHAR = '}';
    private static final char ELEMENT_SEPARATOR_CHAR = ',';
    private static final char LIST_SEPARATOR_CHAR = ':';
    private static final String ITEM_FORMAT = "{id=%s/label=%s/value=%s/description=%s/visible=%s}";

    public EnumerationListParameterImpl() {
        this.selectedIds = new String[0];
    }

    public EnumerationListParameterImpl(String[] selectedIds) {
        this.selectedIds = selectedIds;
    }

    @Override
    public String convertToText() {
        String allItemsList = '{' + this.getItems() + '}';
        String selectedItemsList = '{' + this.getSelectedItems() + '}';
        return allItemsList + ':' + selectedItemsList;
    }

    @Override
    public String getIDLType() {
        return EnumerationListParameterHelper.id();
    }

    private String getItems() {
        StringBuffer itemsAsString = new StringBuffer();
        for (int i = 0; i < this.items.length; ++i) {
            itemsAsString.append(String.format(ITEM_FORMAT, this.items[i].id, this.items[i].label, this.items[i].value, this.items[i].description, this.items[i].visible));
            if (i >= this.items.length - 1) continue;
            itemsAsString.append(',');
        }
        return itemsAsString.toString();
    }

    private String getSelectedItems() {
        StringBuffer itemsAsString = new StringBuffer();
        for (int i = 0; i < this.selectedIds.length; ++i) {
            itemsAsString.append(this.getLabel(this.selectedIds[i]));
            if (i >= this.selectedIds.length - 1) continue;
            itemsAsString.append(',');
        }
        return itemsAsString.toString();
    }

    private String getLabel(String itemId) {
        for (EnumerationItem item : this.items) {
            if (!item.id.equals(itemId)) continue;
            return item.label;
        }
        return null;
    }

    public void addItem(EnumerationItem item) {
        this.vectorItems.add(item);
        this.items = this.vectorItems.toArray(new EnumerationItem[this.vectorItems.size()]);
    }

    public void setSelectedItems(String[] selectedIds) throws InvalidParameterException {
        if (!this.validateItems(selectedIds)) {
            throw new InvalidParameterException();
        }
        this.selectedIds = selectedIds;
    }

    private boolean validateItems(String[] itemsIds) {
        if (this.items == null) {
            return false;
        }
        if (this.items.length == 0) {
            return false;
        }
        for (String itemId : itemsIds) {
            boolean isValid = false;
            for (EnumerationItem item : this.items) {
                if (!item.id.equals(itemId)) continue;
                isValid = true;
                break;
            }
            if (isValid) continue;
            return false;
        }
        return true;
    }
}

