/*
 * Decompiled with CFR 0.152.
 */
package opendreams.proxy;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import openbus.util.OpenBusProxy;
import openbus.util.OpenBusProxyException;
import opendreams.proxy.OpenDreamsException;
import opendreams.proxy.Project;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ValueFactory;
import tecgraf.openbus.DRMAA.JobInfoHelper;
import tecgraf.openbus.data_service.DataAccessDenied;
import tecgraf.openbus.data_service.DataDescription;
import tecgraf.openbus.data_service.IHierarchicalDataService;
import tecgraf.openbus.data_service.IHierarchicalDataServiceHelper;
import tecgraf.openbus.data_service.ServiceFailure;
import tecgraf.openbus.data_service.UnstructuredDataFactory;
import tecgraf.openbus.data_service.UnstructuredDataHelper;
import tecgraf.openbus.data_service.project.ProjectItemDescriptionFactory;
import tecgraf.openbus.opendreams.IOpenDreams;
import tecgraf.openbus.opendreams.IOpenDreamsHelper;
import tecgraf.openbus.opendreams.JobInfoFactory;
import tecgraf.openbus.opendreams.OpenDreamsJobTemplateFactory;
import tecgraf.openbus.opendreams.OpenDreamsJobTemplateHelper;
import tecgraf.openbus.project.ProjectItemDescription;
import tecgraf.openbus.project.ProjectItemDescriptionHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenDreamsProxy {
    public static String DEFAULT_PROPERTIES_FILE = "opendreams.properties";
    public static String PROJECT_PROPERTY = "opendreams.project.name";
    private InputStream privateKey;
    private InputStream acsCertificate;
    private OpenBusProxy proxy;

    public OpenDreamsProxy(Properties properties) throws OpenDreamsException {
        try {
            this.proxy = new OpenBusProxy(properties);
        }
        catch (OpenBusProxyException e) {
            throw new OpenDreamsException("Erro na constru\u00e7\u00e3o do OpenDreamsProxy", e);
        }
    }

    public OpenDreamsProxy() throws OpenDreamsException {
        try {
            this.proxy = new OpenBusProxy(DEFAULT_PROPERTIES_FILE);
        }
        catch (OpenBusProxyException e) {
            throw new OpenDreamsException("Erro na constru\u00e7\u00e3o do OpenDreamsProxy", e);
        }
    }

    public void setPrivatekey(InputStream privateKey) {
        this.privateKey = privateKey;
    }

    public void setACSCertificate(InputStream acsCertificate) {
        this.acsCertificate = acsCertificate;
    }

    public void init() throws OpenDreamsException {
        if (!this.isEnabled()) {
            throw new OpenDreamsException("O proxy para o servi\u00e7o opendreams n\u00e3o est\u00e1 habilitado. Verifique as propriedades openbus.enabled e opendreams.component.export");
        }
        try {
            if (this.privateKey != null) {
                this.proxy.setPrivatekey(this.privateKey);
            }
            if (this.acsCertificate != null) {
                this.proxy.setACSCertificate(this.acsCertificate);
            }
            this.proxy.open();
        }
        catch (OpenBusProxyException e) {
            throw new OpenDreamsException("Erro ao abrir o proxy do OpenBus", e);
        }
        this.registerFactories();
    }

    public void init(String user, String password) throws OpenDreamsException {
        if (!this.isEnabled()) {
            throw new OpenDreamsException("O proxy para o servi\u00e7o opendreams n\u00e3o est\u00e1 habilitado. Verifique as propriedades openbus.enabled e opendreams.component.export");
        }
        try {
            this.proxy.open(user, password);
        }
        catch (OpenBusProxyException e) {
            throw new OpenDreamsException("Erro ao abrir o proxy do OpenBus", e);
        }
        this.registerFactories();
    }

    private void registerFactories() {
        this.proxy.registerFactory(OpenDreamsJobTemplateHelper.id(), (ValueFactory)new OpenDreamsJobTemplateFactory());
        this.proxy.registerFactory(JobInfoHelper.id(), (ValueFactory)new JobInfoFactory());
        this.proxy.registerFactory(ProjectItemDescriptionHelper.id(), (ValueFactory)new ProjectItemDescriptionFactory());
        this.proxy.registerFactory(UnstructuredDataHelper.id(), (ValueFactory)new UnstructuredDataFactory());
    }

    public IOpenDreams getIOpenDreams() throws OpenDreamsException {
        try {
            return IOpenDreamsHelper.narrow(this.proxy.getComponent("opendreams").getFacet(IOpenDreamsHelper.id()));
        }
        catch (OpenBusProxyException e) {
            throw new OpenDreamsException("Erro ao recuperar o servi\u00e7o opendreams", e);
        }
    }

    public IHierarchicalDataService getIDataService() throws OpenDreamsException {
        try {
            return IHierarchicalDataServiceHelper.narrow((Object)this.proxy.getComponent("ProjectDataService").getFacet(IHierarchicalDataServiceHelper.id()));
        }
        catch (OpenBusProxyException e) {
            throw new OpenDreamsException("Erro ao recuperar o servi\u00e7o ProjectDataService", e);
        }
    }

    public Project getProject() throws OpenDreamsException {
        return this.getProject(this.getProjectName());
    }

    public String getProjectName() throws OpenDreamsException {
        String projectName = this.proxy.getProperties().getProperty(PROJECT_PROPERTY);
        if (projectName == null || projectName.trim().equals("")) {
            throw new OpenDreamsException("Propriedade " + PROJECT_PROPERTY + " n\u00e3o definida");
        }
        return projectName;
    }

    public Project getProject(String projectName) throws OpenDreamsException {
        IHierarchicalDataService dataService = this.getIDataService();
        try {
            DataDescription[] rootDescList = dataService.getRoots();
            if (rootDescList.length < 1) {
                throw new OpenDreamsException("O usu\u00e1rio n\u00e3o possui projetos");
            }
            for (int i = 0; i < rootDescList.length; ++i) {
                DataDescription rootDesc = rootDescList[i];
                if (!(rootDesc instanceof ProjectItemDescription)) {
                    throw new OpenDreamsException("Descritor inv\u00e1lido:" + rootDesc.toString());
                }
                if (!rootDesc.fName.equals(projectName)) continue;
                return new Project(rootDesc, this.proxy.getProperties().getUser(), dataService);
            }
        }
        catch (ServiceFailure e) {
            throw new OpenDreamsException("Falha no acesso ao servi\u00e7o de projetos", e);
        }
        catch (DataAccessDenied e) {
            throw new OpenDreamsException("Falha no acesso ao servi\u00e7o de projetos", e);
        }
        return null;
    }

    public List<Project> getAllProjects() throws OpenDreamsException {
        ArrayList<Project> ret = new ArrayList<Project>();
        IHierarchicalDataService dataService = this.getIDataService();
        try {
            DataDescription[] rootDescList = dataService.getRoots();
            for (int i = 0; i < rootDescList.length; ++i) {
                DataDescription rootDesc = rootDescList[i];
                if (!(rootDesc instanceof ProjectItemDescription)) {
                    throw new OpenDreamsException("Descritor inv\u00e1lido:" + rootDesc.toString());
                }
                ret.add(new Project(rootDesc, this.proxy.getProperties().getUser(), dataService));
            }
        }
        catch (ServiceFailure e) {
            throw new OpenDreamsException("Falha no acesso ao servi\u00e7o de projetos (getAllProjects())", e);
        }
        catch (DataAccessDenied e) {
            throw new OpenDreamsException("Falha no acesso ao servi\u00e7o de projetos (getAllProjects())", e);
        }
        return ret;
    }

    public boolean addComponent(String className) throws OpenDreamsException {
        try {
            return this.proxy.addComponent("opendreams", IOpenDreamsHelper.id(), className);
        }
        catch (OpenBusProxyException e) {
            throw new OpenDreamsException("Falha na publica\u00e7\u00e3o do componente opendreams", e);
        }
    }

    public boolean isEnabled() {
        return this.proxy.isEnabled() && this.proxy.getProperties().mayExportComponent("opendreams");
    }

    public void close() {
        this.proxy.close();
    }

    public void setThreadDelegate(String user) {
        this.proxy.setThreadDelegate(user);
    }

    public Properties getProperties() {
        return this.proxy.getProperties();
    }
}

