package br.pucrio.tecgraf.soma.job.domain.model;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Id;
import jakarta.persistence.Table;
import java.util.Objects;

@Entity
@Table(name = "kafka_offset_info")
public class KafkaOffsetInfo {

  @Id
  @Column(name = "partition_id")
  private int partitionId;

  @Column(name = "partition_offset")
  private long partitionOffset;

  public KafkaOffsetInfo() {}

  public KafkaOffsetInfo(int partitionId, long offset) {
    this.partitionId = partitionId;
    this.partitionOffset = offset;
  }

  public int getPartitionId() {
    return partitionId;
  }

  public void setPartitionId(int partitionId) {
    this.partitionId = partitionId;
  }

  public long getPartitionOffset() {
    return partitionOffset;
  }

  public void setPartitionOffset(long partitionOffset) {
    this.partitionOffset = partitionOffset;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    KafkaOffsetInfo that = (KafkaOffsetInfo) o;
    return this.partitionId == that.partitionId && this.partitionOffset == that.partitionOffset;
  }

  @Override
  public int hashCode() {
    return Objects.hash(partitionId, partitionOffset);
  }
}
