/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.domain.model;

import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.job.domain.model.JobAlgorithmParameter;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;

@Entity
@Table(name="job_algorithms")
public class JobAlgorithm
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="job_algorithms_generator")
    @SequenceGenerator(name="job_algorithms_generator", sequenceName="public.job_algorithms_seq", allocationSize=1)
    @Column(name="id", updatable=false, nullable=false)
    private Long id;
    @Column(name="algo_id", nullable=false)
    private String algorithmId;
    @Column(name="algo_version", nullable=false)
    private String algorithmVersion;
    @Column(name="algo_name", nullable=false)
    private String algorithmName;
    @Column(name="flow_node_id", nullable=true)
    private Integer flowNodeId;
    @Column(name="flow_node_exit_code", nullable=true)
    private Integer flowNodeExitCode;
    @Column(name="flow_node_progress", nullable=true)
    private String flowNodeProgress;
    @ManyToOne
    @OnDelete(action=OnDeleteAction.CASCADE)
    @JoinColumn(name="job_id", nullable=false)
    private Job job;
    @OneToMany(mappedBy="jobAlgorithm", fetch=FetchType.EAGER, cascade={CascadeType.ALL}, orphanRemoval=true)
    @Fetch(value=FetchMode.SUBSELECT)
    private List<JobAlgorithmParameter> parameters = new ArrayList<JobAlgorithmParameter>();

    public JobAlgorithm() {
    }

    public JobAlgorithm(String algorithmId, String algorithmName) {
        this.algorithmId = algorithmId;
        this.algorithmName = algorithmName;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getAlgorithmId() {
        return this.algorithmId;
    }

    public void setAlgorithmId(String algorithmId) {
        this.algorithmId = algorithmId;
    }

    public String getAlgorithmVersion() {
        return this.algorithmVersion;
    }

    public void setAlgorithmVersion(String algorithmVersion) {
        this.algorithmVersion = algorithmVersion;
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public void setAlgorithmName(String algorithmName) {
        this.algorithmName = algorithmName;
    }

    public Integer getFlowNodeId() {
        return this.flowNodeId;
    }

    public void setFlowNodeId(Integer flowNodeId) {
        this.flowNodeId = flowNodeId;
    }

    public Job getJob() {
        return this.job;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public List<JobAlgorithmParameter> getParameters() {
        return this.parameters;
    }

    public void addParameter(JobAlgorithmParameter parameter) {
        parameter.setJobAlgorithm(this);
        this.parameters.add(parameter);
    }

    public Integer getFlowNodeExitCode() {
        return this.flowNodeExitCode;
    }

    public void setFlowNodeExitCode(Integer flowNodeExitCode) {
        this.flowNodeExitCode = flowNodeExitCode;
    }

    public String getFlowNodeProgress() {
        return this.flowNodeProgress;
    }

    public void setFlowNodeProgress(String flowNodeProgress) {
        this.flowNodeProgress = flowNodeProgress;
    }
}

