package br.pucrio.tecgraf.soma.serviceapi.persistence.repository.impl;

import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.Repository;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;

import javax.persistence.EntityManager;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import java.util.List;

public abstract class JPARepository<C> implements Repository<C, JPASpecification<C>> {

	@Override
	public void add(C element) {
		getEntityManager().persist(element);
	}

	@Override
	public void remove(C element) {
		getEntityManager().remove(element);
	}

	@Override
	public void update(C element) {
		getEntityManager().flush();
	}

	@Override
	public List<C> find(JPASpecification<C> specification) {
		CriteriaBuilder criteriaBuilder = getEntityManager().getCriteriaBuilder();
		CriteriaQuery<C> criteriaQuery = criteriaBuilder.createQuery(specification.getType());
		Root<C> root = criteriaQuery.from(specification.getType());
		Predicate predicate = specification.toPredicate(root, criteriaBuilder);
		criteriaQuery.where(predicate);
		List<C> result = getEntityManager().createQuery(criteriaQuery).getResultList();
		return result;
	}

	@Override
	public long count(JPASpecification<C> specification) {
		CriteriaBuilder criteriaBuilder = getEntityManager().getCriteriaBuilder();
		CriteriaQuery<Long> criteriaQuery = criteriaBuilder.createQuery(Long.class);
		Root<C> root = criteriaQuery.from(specification.getType());
		criteriaQuery.select(criteriaBuilder.count(root));
		Predicate predicate = specification.toPredicate(root, criteriaBuilder);
		criteriaQuery.where(predicate);
		long result = getEntityManager().createQuery(criteriaQuery).getSingleResult();
		return result;
	}

  @Override
  public C first(JPASpecification<C> specification) {
    List<C> elements = find(specification);
    if (elements.size() == 0) {
      return null;
    } else {
      return elements.get(0);
    }
  }

	public abstract EntityManager getEntityManager();
}
