package br.pucrio.tecgraf.soma.serviceapi.persistence.specification.impl;


import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;

import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;


public class AllSpecification<T> extends JPASpecification<T> {

	private Class<T> typeParameterClass;

	public AllSpecification(Class<T>  typeParameterClass) {
		this.typeParameterClass = typeParameterClass;
	}

	@Override
	public Predicate toPredicate(Root<T> root, CriteriaBuilder cb) {
		return cb.and();
	}
	
	@Override
	public boolean isSatisfiedBy(T element) {
		return true;
	}
	
	@Override
	public Class<T> getType() {
		return typeParameterClass;
	}
	
}
