/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.serviceapi.persistence.repository.impl;

import com.github.tennaito.rsql.misc.ArgumentFormatException;
import com.github.tennaito.rsql.misc.ArgumentParser;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExtendedArgumentParser
implements ArgumentParser {
    private static final Logger LOG = Logger.getLogger(ExtendedArgumentParser.class.getName());

    public <T> T parse(String argument, Class<T> type) throws ArgumentFormatException, IllegalArgumentException {
        LOG.log(Level.INFO, "Parsing argument ''{0}'' as type {1}, thread {2}", new Object[]{argument, type.getSimpleName(), Thread.currentThread().getName()});
        if (argument == null || "null".equals(argument.trim().toLowerCase())) {
            return null;
        }
        try {
            if (type.equals(String.class)) {
                return (T)argument;
            }
            if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
                return (T)Integer.valueOf(argument);
            }
            if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
                return (T)Boolean.valueOf(argument);
            }
            if (type.isEnum()) {
                return Enum.valueOf(type, argument.toUpperCase());
            }
            if (type.equals(Float.class) || type.equals(Float.TYPE)) {
                return (T)Float.valueOf(argument);
            }
            if (type.equals(Double.class) || type.equals(Double.TYPE)) {
                return (T)Double.valueOf(argument);
            }
            if (type.equals(Long.class) || type.equals(Long.TYPE)) {
                return (T)Long.valueOf(argument);
            }
            if (type.equals(BigDecimal.class)) {
                return (T)new BigDecimal(argument);
            }
        }
        catch (IllegalArgumentException ex) {
            throw new ArgumentFormatException(argument, type);
        }
        if (type.equals(Date.class)) {
            return (T)this.parseDate(argument, type);
        }
        if (type.equals(LocalDateTime.class)) {
            return (T)this.parseLocalDateTime(argument, type);
        }
        try {
            LOG.log(Level.INFO, "Trying to get and invoke valueOf(String s) method on {0}", type);
            Method method = type.getMethod("valueOf", String.class);
            return (T)method.invoke(type, argument);
        }
        catch (InvocationTargetException ex) {
            throw new ArgumentFormatException(argument, type);
        }
        catch (ReflectiveOperationException ex) {
            LOG.log(Level.WARNING, "{0} does not have method valueOf(String s) or method is inaccessible", type);
            throw new IllegalArgumentException("Cannot parse argument type " + type);
        }
    }

    private <T> Date parseDate(String argument, Class<T> type) {
        LocalDateTime dateTime = this.parseLocalDateTime(argument, type);
        return Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    private <T> LocalDateTime parseLocalDateTime(String argument, Class<T> type) {
        try {
            DateTimeFormatter formatter = new DateTimeFormatterBuilder().appendPattern("yyyy/MM/dd[[' ']['T']HH:mm[:ss][.SSS]]x").parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter();
            ZonedDateTime zonedDateTime = ZonedDateTime.parse(argument, formatter);
            return LocalDateTime.ofInstant(zonedDateTime.toInstant(), ZoneOffset.UTC);
        }
        catch (DateTimeParseException ex) {
            throw new ArgumentFormatException(argument, type);
        }
    }

    public <T> List<T> parse(List<String> arguments, Class<T> type) throws ArgumentFormatException, IllegalArgumentException {
        ArrayList<T> castedArguments = new ArrayList<T>(arguments.size());
        for (String argument : arguments) {
            castedArguments.add(this.parse(argument, type));
        }
        return castedArguments;
    }
}

