/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.domain;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.AfterDomainEventPublication;
import org.springframework.data.domain.DomainEvents;
import org.springframework.util.Assert;

public class AbstractAggregateRoot {
    private final transient List<Object> domainEvents = new ArrayList<Object>();

    protected <T> T registerEvent(T event) {
        Assert.notNull(event, "Domain event must not be null!");
        this.domainEvents.add(event);
        return event;
    }

    @AfterDomainEventPublication
    public void clearDomainEvents() {
        this.domainEvents.clear();
    }

    @DomainEvents
    public List<Object> getDomainEvents() {
        return this.domainEvents;
    }
}

