/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.domain.model;

import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Index;
import javax.persistence.Lob;
import javax.persistence.Table;

@Entity
@Table(name="lost_events", indexes={@Index(columnList="event_id", name="event_id_idx"), @Index(columnList="kafka_partition_id, kafka_offset", name="kafka_partition_offset_idx")})
public class LostEvent {
    @Id
    @GeneratedValue
    private long id;
    @Column(name="event_id")
    private String eventId;
    @Column(name="kafka_partition_id")
    private int kafkaPartition;
    @Column(name="kafka_offset")
    private long kafkaOffset;
    @Lob
    @Column(name="raw_string")
    private String rawString;

    public LostEvent(String eventId, int kafkaPartition, long kafkaOffset, String rawString) {
        this.eventId = eventId;
        this.kafkaPartition = kafkaPartition;
        this.kafkaOffset = kafkaOffset;
        this.rawString = rawString;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public int getKafkaPartition() {
        return this.kafkaPartition;
    }

    public void setKafkaPartition(int kafkaPartition) {
        this.kafkaPartition = kafkaPartition;
    }

    public long getKafkaOffset() {
        return this.kafkaOffset;
    }

    public void setKafkaOffset(long kafkaOffset) {
        this.kafkaOffset = kafkaOffset;
    }

    public String getRawString() {
        return this.rawString;
    }

    public void setRawString(String rawString) {
        this.rawString = rawString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LostEvent lostEvent = (LostEvent)o;
        return this.kafkaPartition == lostEvent.kafkaPartition && this.kafkaOffset == lostEvent.kafkaOffset && this.eventId.equals(lostEvent.eventId) && this.rawString.equals(lostEvent.rawString);
    }

    public int hashCode() {
        return Objects.hash(this.eventId, this.kafkaPartition, this.kafkaOffset, this.rawString);
    }
}

