package br.pucrio.tecgraf.soma.job.api;

import br.pucrio.tecgraf.soma.job.api.model.*;
import br.pucrio.tecgraf.soma.job.api.JobsviewApiService;
import br.pucrio.tecgraf.soma.job.api.factories.JobsviewApiServiceFactory;

import io.swagger.annotations.ApiParam;
import io.swagger.jaxrs.*;

import br.pucrio.tecgraf.soma.job.api.model.Error;
import br.pucrio.tecgraf.soma.job.api.model.JobViewResponse;

import java.util.Map;
import java.util.List;
import br.pucrio.tecgraf.soma.job.api.NotFoundException;

import java.io.InputStream;

import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;

import javax.servlet.ServletConfig;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.*;
import javax.validation.constraints.*;
import javax.validation.Valid;

@Path("/jobsview")


@io.swagger.annotations.Api(description = "the jobsview API")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJerseyServerCodegen", date = "2019-08-13T18:14:58.459Z[Etc/UTC]")
public class JobsviewApi  {
   private final JobsviewApiService delegate;

   public JobsviewApi(@Context ServletConfig servletContext) {
      JobsviewApiService delegate = null;

      if (servletContext != null) {
         String implClass = servletContext.getInitParameter("JobsviewApi.implementation");
         if (implClass != null && !"".equals(implClass.trim())) {
            try {
               delegate = (JobsviewApiService) Class.forName(implClass).newInstance();
            } catch (Exception e) {
               throw new RuntimeException(e);
            }
         } 
      }

      if (delegate == null) {
         delegate = JobsviewApiServiceFactory.getJobsviewApi();
      }

      this.delegate = delegate;
   }

    @GET
    
    
    @Produces({ "application/json;", "application/json" })
    @io.swagger.annotations.ApiOperation(value = "Fetch filtered list of jobs from view job_view.", notes = "This endpoint list all jobs that match the parameters criteria", response = JobViewResponse.class, tags={ "Jobs", })
    @io.swagger.annotations.ApiResponses(value = { 
        @io.swagger.annotations.ApiResponse(code = 200, message = "Successful operation.", response = JobViewResponse.class),
        
        @io.swagger.annotations.ApiResponse(code = 403, message = "if the authenticated user does not have permission to access the project.", response = Void.class),
        
        @io.swagger.annotations.ApiResponse(code = 400, message = "bad parameters. The error code are: <br> 1. If a invalid limit was used 2. If a invalid offset was used 3. If a invalid sort was used ", response = Error.class) })
    public Response jobsviewGet(@ApiParam(value = "The query in RSQL format.") @QueryParam("q") String q
,@ApiParam(value = "The zero based position of the first item to retrieve") @QueryParam("offset") Integer offset
,@ApiParam(value = "The number of items to retrieve") @QueryParam("limit") Integer limit
,@ApiParam(value = "Parameter indicating the sorting direction of the results") @QueryParam("asc") Boolean asc
,@ApiParam(value = "Attribute that should be used to sort the results") @QueryParam("attr") String attr
,@ApiParam(value = "Add algorithm's parameter values.", defaultValue="true") @DefaultValue("true") @QueryParam("showParam") Boolean showParam
,@ApiParam(value = "The locale adopted for internationalization. When provided, this locale defines the language for message responses.") @QueryParam("locale") String locale
,@Context SecurityContext securityContext)
    throws NotFoundException {
        return delegate.jobsviewGet(q,offset,limit,asc,attr,showParam,locale,securityContext);
    }
}
