package br.pucrio.tecgraf.soma.job.application.appservice;

import br.pucrio.tecgraf.soma.job.api.model.JobPagination;
import br.pucrio.tecgraf.soma.job.application.Tuple;
import br.pucrio.tecgraf.soma.job.application.service.JobService;
import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.job.domain.model.JobView;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

@Service
public class JobAppService {

  @Autowired JobService service;

  @Transactional
  public void markJobAsDeleted(String jobId) {
    service.markJobAsDeleted(jobId);
  }

  @Transactional
  public void markJobsAsDeleted(List<String> jobIds) {
    service.markJobsAsDeleted(jobIds);
  }

  @Transactional
  public Tuple<List<Job>, Integer> findJobs(
      String rsqlQuery, Integer offset, Integer limit, Boolean ascending, String sortAttribute) {
    List<Job> jobs = service.findJobs(rsqlQuery, offset, limit, ascending, sortAttribute);
    int total = (int) service.count(rsqlQuery);
    return new Tuple<>(jobs, total);
  }

  @Transactional
  public Tuple<List<JobView>, Integer> findJobsFromView(
    String rsqlQuery, Integer offset, Integer limit, Boolean ascending, String sortAttribute) {
    List<JobView> jobs = service.findJobsFromView(rsqlQuery, offset, limit, ascending, sortAttribute);
    int total = (int) service.countFromView(rsqlQuery);
    return new Tuple<>(jobs, total);
  }

  public JobPagination buildPaginationInfo(Integer total, Integer offset, Integer limit) {
    JobPagination pagination = new JobPagination();
    pagination.total(total);
    pagination.limit(limit);
    if (offset == null) {
      pagination.offset(0);
    } else {
      int newOffset;
      if (offset >= total) {
        if ( total == 0) {
          newOffset = 0;
        } else if (total % limit == 0) {
          newOffset = total - limit;
        } else {
          newOffset = total - (total % limit);
        }
      } else {
        newOffset = offset;
      }
      pagination.offset(newOffset);
    }
    return pagination;
  }
}
