/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.controller;

import br.pucrio.tecgraf.soma.job.api.JobsApi;
import br.pucrio.tecgraf.soma.job.api.NotFoundException;
import br.pucrio.tecgraf.soma.job.api.model.Algorithm;
import br.pucrio.tecgraf.soma.job.api.model.AlgorithmParameter;
import br.pucrio.tecgraf.soma.job.api.model.AlgorithmResponse;
import br.pucrio.tecgraf.soma.job.api.model.ExitStatus;
import br.pucrio.tecgraf.soma.job.api.model.Job;
import br.pucrio.tecgraf.soma.job.api.model.JobAlgorithm;
import br.pucrio.tecgraf.soma.job.api.model.JobData;
import br.pucrio.tecgraf.soma.job.api.model.JobPagination;
import br.pucrio.tecgraf.soma.job.api.model.JobResponse;
import br.pucrio.tecgraf.soma.job.api.model.JobType;
import br.pucrio.tecgraf.soma.job.api.model.NewComment;
import br.pucrio.tecgraf.soma.job.api.model.StatusChangeHistory;
import br.pucrio.tecgraf.soma.job.application.Tuple;
import br.pucrio.tecgraf.soma.job.application.appservice.JobAppService;
import br.pucrio.tecgraf.soma.job.domain.dto.DomainMapper;
import br.pucrio.tecgraf.soma.job.domain.model.JobView;
import br.pucrio.tecgraf.soma.job.domain.model.StatusType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.ServiceUnavailableException;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class JobController
extends JobsApi {
    @Autowired
    private JobAppService jobAppService;
    @Autowired
    private HttpServletRequest request;
    private static final Integer maximumLimit = 1000;
    private static final Integer invalidLimit = -1;

    public JobController() {
        super(null);
    }

    public Response jobsHistoryAlgorithmsGet(String q, String locale, SecurityContext securityContext) throws NotFoundException, ServiceUnavailableException {
        AlgorithmResponse response = new AlgorithmResponse();
        response.setProcessingDate(Long.valueOf(System.currentTimeMillis()));
        String accessToken = this.request.getHeader("Authorization");
        if (accessToken == null || accessToken.isEmpty()) {
            return Response.status((int)HttpStatus.UNAUTHORIZED.value()).build();
        }
        q = this.filterUserProjects(locale, accessToken, q);
        response.setAlgorithms(Arrays.asList((Object[])DomainMapper.convert((Object)this.jobAppService.findDistinctAlgorithms(q), Algorithm[].class)));
        return Response.ok().entity((Object)response).build();
    }

    public Response jobsHistoryJobIdCommentPut(String jobId, NewComment requestBody, String locale, SecurityContext securityContext) throws NotFoundException, ForbiddenException, ServiceUnavailableException {
        String accessToken = this.request.getHeader("Authorization");
        if (accessToken == null || accessToken.isEmpty()) {
            return Response.status((int)HttpStatus.UNAUTHORIZED.value()).build();
        }
        if (requestBody == null || requestBody.getNewComment() == null) {
            return Response.status((int)HttpStatus.BAD_REQUEST.value(), (String)"Missing body with newComment parameter").build();
        }
        List userProjects = this.jobAppService.getUserProjects(locale, accessToken);
        this.jobAppService.editJobComment(jobId, requestBody.getNewComment(), userProjects);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response jobsHistoryDelete(List<String> jobIds, String locale, SecurityContext securityContext) throws NotFoundException {
        this.jobAppService.markJobsAsDeleted(jobIds);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    private Integer getLimitValue(Integer limit) {
        if (limit == null) {
            return maximumLimit;
        }
        if (limit > 0 && limit <= maximumLimit) {
            return limit;
        }
        return invalidLimit;
    }

    public Response jobsHistoryGet(String q, Integer offset, Integer limit, Boolean asc, String attr, Boolean showParam, String locale, SecurityContext securityContext) throws NotFoundException, ServiceUnavailableException {
        if ((limit = this.getLimitValue(limit)) == invalidLimit) {
            return Response.status((int)HttpStatus.BAD_REQUEST.value(), (String)"Invalid limit value").build();
        }
        if (offset != null && offset < 0) {
            return Response.status((int)HttpStatus.BAD_REQUEST.value(), (String)"Offset must be a positive number or zero").build();
        }
        String accessToken = this.request.getHeader("Authorization");
        if (accessToken == null || accessToken.isEmpty()) {
            return Response.status((int)HttpStatus.UNAUTHORIZED.value()).build();
        }
        Tuple tuple = this.jobAppService.findJobsFromView(q = this.filterUserProjectsAndHandleDeleted(locale, accessToken, q), offset, limit, asc, attr);
        if (tuple == null) {
            JobResponse response = new JobResponse();
            return Response.ok().entity((Object)response).build();
        }
        JobPagination pagination = this.jobAppService.buildPaginationInfo((Integer)tuple.getSecond(), offset, limit);
        if (offset != pagination.getOffset()) {
            tuple = this.jobAppService.findJobsFromView(q, pagination.getOffset(), limit, asc, attr);
        }
        return this.responseJobs(tuple, pagination, showParam.booleanValue());
    }

    public String filterUserProjects(String locale, String accessToken, String q) throws NotFoundException, ServiceUnavailableException {
        String projectsQuery = this.getUserProjectsPredicate(locale, accessToken, "job.projectId");
        q = q == null || q.length() == 0 ? projectsQuery : String.format("(%s);(%s)", q, projectsQuery);
        return q;
    }

    public String filterUserProjectsAndHandleDeleted(String locale, String accessToken, String q) throws NotFoundException, ServiceUnavailableException {
        String projectsQuery = this.getUserProjectsPredicate(locale, accessToken, "projectId");
        String baseQuery = "isDeleted==false;" + projectsQuery;
        q = q == null || q.length() == 0 ? baseQuery : (!q.contains("isDeleted") ? String.format("(%s);(%s)", q, baseQuery) : String.format("(%s);(%s)", q, projectsQuery));
        return q;
    }

    public String getUserProjectsPredicate(String locale, String accessToken, String projectColumn) throws NotFoundException, ServiceUnavailableException {
        List projectIds = this.jobAppService.getUserProjects(locale, accessToken);
        if (projectIds.isEmpty()) {
            throw new NotFoundException(HttpStatus.NOT_FOUND.value(), "User has access to no projects");
        }
        StringBuilder projectsQuery = new StringBuilder(projectColumn);
        projectsQuery.append("=in=(");
        for (String projectId : projectIds) {
            projectsQuery.append(projectId);
            projectsQuery.append(",");
        }
        projectsQuery.deleteCharAt(projectsQuery.lastIndexOf(","));
        projectsQuery.append(")");
        return projectsQuery.toString();
    }

    private Response responseJobs(Tuple<List<JobView>, Integer> tuple, JobPagination pagination, boolean showParam) {
        JobData data = new JobData();
        data.processingDate(Long.valueOf(System.currentTimeMillis()));
        List convertedJobList = this.convertToJobList((JobView[])DomainMapper.convert((Object)tuple.getFirst(), JobView[].class), showParam);
        data.jobs(convertedJobList);
        JobResponse response = new JobResponse();
        response.data(data);
        response.pagination(pagination);
        return Response.ok().entity((Object)response).build();
    }

    private List<Job> convertToJobList(JobView[] jobs, boolean showParam) {
        LinkedHashMap<String, Job> jobsMap = new LinkedHashMap<String, Job>();
        HashMap jobStatusMap = new HashMap();
        HashMap jobAlgoMap = new HashMap();
        HashMap jobAlgoParamMap = new HashMap();
        for (JobView jobView : jobs) {
            JobAlgorithm jobAlgorithm;
            List parameters;
            List parameterValues;
            AlgorithmParameter algoParameter;
            StatusType statusType;
            String statusStr;
            Map statusHistoryMap;
            String jobId = jobView.getJobId();
            if (!jobsMap.containsKey(jobId)) {
                Job newJob = this.createJob(jobView);
                jobStatusMap.put(jobId, new HashMap());
                jobAlgoMap.put(jobId, new HashMap());
                jobAlgoParamMap.put(jobId, new HashMap());
                jobsMap.put(jobId, newJob);
            }
            if (!jobView.getAutomaticallyMachineSelection().booleanValue()) {
                String selectedMachine = jobView.getSelectedMachine();
                Job job = (Job)jobsMap.get(jobId);
                List submissionMachines = job.getSubmissionMachines();
                if (submissionMachines != null) {
                    if (!submissionMachines.contains(selectedMachine)) {
                        job.addSubmissionMachinesItem(selectedMachine);
                    }
                } else {
                    job.addSubmissionMachinesItem(selectedMachine);
                }
            }
            if (!(statusHistoryMap = (Map)jobStatusMap.get(jobId)).containsKey(statusStr = (statusType = jobView.getJobStatus()).toString())) {
                StatusChangeHistory sch = new StatusChangeHistory();
                sch.setStatus((br.pucrio.tecgraf.soma.job.api.model.StatusType)DomainMapper.convert((Object)statusType, br.pucrio.tecgraf.soma.job.api.model.StatusType.class));
                sch.setTimestamp(jobView.getJobStatusTimestamp().toString());
                statusHistoryMap.put(statusStr, true);
                ((Job)jobsMap.get(jobId)).addStatusHistoryItem(sch);
            }
            Map algorithmMap = (Map)jobAlgoMap.get(jobId);
            String algorithmId = jobView.getAlgorithmId();
            Long jaId = jobView.getJaId();
            String keyJaId = "";
            if (jaId != null) {
                keyJaId = Long.toString(jaId);
            }
            if (!algorithmMap.containsKey(keyJaId)) {
                JobAlgorithm jobAlgorithm2 = new JobAlgorithm();
                jobAlgorithm2.setAlgorithmId(algorithmId);
                jobAlgorithm2.setAlgorithmVersion(jobView.getAlgorithmVersion());
                jobAlgorithm2.setAlgorithmName(jobView.getAlgorithmName());
                jobAlgorithm2.setFlowNodeId(jobView.getFlowNodeId());
                jobAlgorithm2.setParameters(new ArrayList());
                algorithmMap.put(keyJaId, jobAlgorithm2);
                ((Job)jobsMap.get(jobId)).addAlgorithmsItem(jobAlgorithm2);
            }
            Map paramMap = (Map)jobAlgoParamMap.get(jobId);
            if (jobView.getParameterId() == null || jobView.getParamValue() == null || jobView.getParamValue().isEmpty()) continue;
            String paramId = jobView.getParameterId() + keyJaId;
            if (!paramMap.containsKey(paramId)) {
                algoParameter = new AlgorithmParameter();
                algoParameter.setId(BigDecimal.valueOf(jobView.getJobAlgoParamId()));
                algoParameter.setParameterId(jobView.getParameterId());
                algoParameter.setLabel(jobView.getParamLabel());
                algoParameter.setType(jobView.getParamType());
                paramMap.put(paramId, algoParameter);
            }
            if ((parameterValues = (algoParameter = (AlgorithmParameter)paramMap.get(paramId)).getValue()) == null || !parameterValues.contains(jobView.getParamValue())) {
                algoParameter.addValueItem(jobView.getParamValue());
            }
            if (!showParam || (parameters = (jobAlgorithm = (JobAlgorithm)algorithmMap.get(keyJaId)).getParameters()) != null && parameters.indexOf(algoParameter) != -1) continue;
            jobAlgorithm.addParametersItem(algoParameter);
        }
        return new LinkedList<Job>(jobsMap.values());
    }

    private Job createJob(JobView jobView) {
        Job newJob = new Job();
        newJob.setJobId(jobView.getJobId());
        newJob.groupId(jobView.getGroupId());
        newJob.setProjectId(jobView.getProjectId());
        newJob.jobOwner(jobView.getJobOwner());
        newJob.setAutomaticallyMachineSelection(jobView.getAutomaticallyMachineSelection());
        newJob.setNumberOfProcesses(jobView.getNumberOfProcesses());
        newJob.setNumberOfProcessesByMachine(jobView.getNumberOfProcessesByMachine());
        newJob.setSubmissionTime(jobView.getSubmissionTime().toString());
        newJob.setDescription(jobView.getDescription());
        newJob.setPriority(jobView.getPriority());
        newJob.setMultipleExecution(jobView.getMultipleExecution());
        newJob.setJobType((JobType)DomainMapper.convert((Object)jobView.getJobType(), JobType.class));
        newJob.setNumberOfAttempts(jobView.getNumberOfRetries());
        newJob.setExecutionMachine(jobView.getExecutionMachine());
        if (jobView.getEndTime() != null) {
            newJob.setEndTime(jobView.getEndTime().toString());
        }
        newJob.setExitCode(jobView.getExitCode());
        newJob.setGuiltyNodeId(jobView.getGuiltyNodeId());
        if (jobView.getExitStatus() != null) {
            newJob.setExitStatus((ExitStatus)DomainMapper.convert((Object)jobView.getExitStatus(), ExitStatus.class));
        }
        newJob.setCpuTime(jobView.getCpuTime());
        newJob.setWallclockTime(jobView.getWallclockTime());
        newJob.setRamMemory(jobView.getRamMemory());
        newJob.setFlowId(jobView.getFlowId());
        newJob.setFlowVersion(jobView.getFlowVersion());
        newJob.setFlowName(jobView.getFlowName());
        if (jobView.getLastModifiedTime() != null) {
            newJob.setLastModifiedTime(jobView.getLastModifiedTime().toString());
        }
        return newJob;
    }
}

