/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.service;

import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.job.domain.model.JobAlgorithm;
import br.pucrio.tecgraf.soma.job.domain.model.JobView;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository.JobAlgorithmRepository;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository.JobRepository;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository.JobViewRepository;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.specification.JobByIdSpecification;
import br.pucrio.tecgraf.soma.job.infrastructure.persistence.specification.JobsInListSpecification;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.Sort;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.JPASpecification;
import br.pucrio.tecgraf.soma.serviceapi.persistence.specification.impl.RSQLSpecification;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.NoResultException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.NotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class JobService {
    @Autowired
    private JobRepository jobRepository;
    @Autowired
    private JobViewRepository jobViewRepository;
    @Autowired
    private JobAlgorithmRepository jobAlgorithmRepository;

    JobService() {
    }

    JobService(JobRepository jobRepository) {
        this.jobRepository = jobRepository;
    }

    JobService(JobRepository jobRepository, JobViewRepository jobViewRepository) {
        this.jobRepository = jobRepository;
        this.jobViewRepository = jobViewRepository;
    }

    JobService(JobRepository jobRepository, JobViewRepository jobViewRepository, JobAlgorithmRepository jobAlgorithmRepository) {
        this.jobRepository = jobRepository;
        this.jobViewRepository = jobViewRepository;
        this.jobAlgorithmRepository = jobAlgorithmRepository;
    }

    @Transactional
    public List<JobAlgorithm> findDistinctAlgorithms(String rsqlQuery) {
        return this.jobAlgorithmRepository.findDistinct((JPASpecification)new RSQLSpecification(rsqlQuery, this.jobAlgorithmRepository.getEntityManager()));
    }

    @Transactional
    public void editJobComment(String jobId, String newComment, List<String> userProjects) throws NotFoundException, ForbiddenException {
        Job job = null;
        try {
            job = (Job)this.jobRepository.first((JPASpecification)new JobByIdSpecification(jobId), new Sort[0]);
        }
        catch (NoResultException e) {
            System.err.println("Job " + jobId + " not found!");
            e.printStackTrace();
        }
        if (job == null) {
            throw new NotFoundException("Job not found: " + jobId);
        }
        if (!userProjects.contains(job.getProjectId())) {
            throw new ForbiddenException("User has no permission to edit this job");
        }
        job.setDescription(newComment);
        this.jobRepository.update((Object)job);
    }

    @Transactional
    public void markJobAsDeleted(String jobId) {
        Job job = (Job)this.jobRepository.first((JPASpecification)new JobByIdSpecification(jobId), new Sort[0]);
        job.setDeleted(true);
        this.jobRepository.update((Object)job);
    }

    @Transactional
    public void markJobsAsDeleted(List<String> jobIds) {
        JobsInListSpecification spec = new JobsInListSpecification(jobIds);
        List jobs = this.jobRepository.find((JPASpecification)spec, new Sort[0]);
        for (Job job : jobs) {
            job.setDeleted(true);
            this.jobRepository.update((Object)job);
        }
    }

    @Transactional
    public List<JobView> findJobsFromView(String rsqlQuery, Integer offset, Integer limit, Boolean ascending, String sortAttribute) {
        ArrayList<Sort> sorts = new ArrayList<Sort>();
        if (ascending != null) {
            sorts.add(new Sort(sortAttribute, ascending.booleanValue()));
        }
        return this.jobViewRepository.find((JPASpecification)new RSQLSpecification(rsqlQuery, this.jobViewRepository.getEntityManager()), limit, offset, sorts.toArray(new Sort[0]));
    }

    @Transactional
    public long countFromView(String rsqlQuery) {
        return this.jobViewRepository.count((JPASpecification)new RSQLSpecification(rsqlQuery, this.jobViewRepository.getEntityManager()));
    }
}

