package br.pucrio.tecgraf.soma.job.application.appservice;

import br.pucrio.tecgraf.soma.job.api.model.JobResponse;
import br.pucrio.tecgraf.soma.job.application.Tuple;
import br.pucrio.tecgraf.soma.job.application.configuration.Constants.Config;
import br.pucrio.tecgraf.soma.job.application.service.JobService;
import br.pucrio.tecgraf.soma.job.domain.model.Job;
import br.pucrio.tecgraf.soma.job.domain.model.JobAlgorithm;
import br.pucrio.tecgraf.soma.serviceapi.configuration.ServiceConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

import javax.ws.rs.ForbiddenException;
import javax.ws.rs.ServiceUnavailableException;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@Service
public class JobAppService {

  @Autowired
  private JobService service;

  @Autowired
  private ServiceConfiguration config;

  @Autowired
  private RestTemplate restTemplate;

  @Transactional
  public List<JobAlgorithm> findDistinctAlgorithms(String rsqlQuery) {
    return service.findDistinctAlgorithms(rsqlQuery);
  }

  @Transactional
  public void editJobComment(String jobId, String newComment, List<String> userProjects)
          throws ForbiddenException {
    service.editJobComment(jobId, newComment, userProjects);
  }

  @Transactional
  public void markJobAsDeleted(String jobId) {
    service.markJobAsDeleted(jobId);
  }

  @Transactional
  public void markJobsAsDeleted(List<String> jobIds) {
    service.markJobsAsDeleted(jobIds);
  }

  @Transactional
  public void findJobs(String rsqlQuery,
                       int limit,
                       int offset,
                       boolean ascending,
                       String sortAttribute,
                       JobResponse response) {
    service.findJobs(rsqlQuery, limit, offset, ascending, sortAttribute, response);
  }

  @Transactional
  public void findGroupedJobs(String rsqlQuery,
                              int limit,
                              int offset,
                              boolean ascending,
                              String sortAttribute,
                              JobResponse response) {
    service.findGroupedJobs(rsqlQuery, limit, offset, ascending, sortAttribute, response);
  }

  /**
   * Busca os projetos que o usuário tem acesso via API REST do serviço de projetos do CSGrid.
   * @param locale o locale.
   * @param accessToken o token para autenticação da chamada à API REST.
   * @return a lista de ids dos projetos que o usuário tem acesso.
   */
  public List<String> getUserProjects(String locale, String accessToken)
          throws ServiceUnavailableException {
    String uri = config.getValue(Config.SERVER_BASE_URL.option.getLongName());
    UriComponentsBuilder builder = UriComponentsBuilder
            .fromHttpUrl(uri)
            .path("projects/permissions");

    if (locale != null) builder.queryParam("locale", locale);

    HttpHeaders headers = new HttpHeaders();
    headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
    headers.set(HttpHeaders.AUTHORIZATION, accessToken);

    try {
      ResponseEntity<String[]> response = restTemplate.exchange(
              builder.toUriString(),
              HttpMethod.GET,
              new HttpEntity<>(headers),
              String[].class);
      return Arrays.asList(response.getBody());
    }
    catch (RestClientException e) {
      e.printStackTrace();
      throw new ServiceUnavailableException("Failed retrieving user projects");
    }
  }
}
