/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.api.model;

import br.pucrio.tecgraf.soma.job.application.JsonUndefined;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.swagger.annotations.ApiModelProperty;
import jakarta.validation.Valid;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@JsonPropertyOrder(value={"id", "parameterId", "label", "type", "value"})
@JsonInclude(value=JsonInclude.Include.CUSTOM, valueFilter=JsonUndefined.class)
public class AlgorithmParameter {
    public static final String JSON_PROPERTY_ID = "id";
    @JsonProperty(value="id")
    private BigDecimal id;
    public static final String JSON_PROPERTY_PARAMETER_ID = "parameterId";
    @JsonProperty(value="parameterId")
    private String parameterId;
    public static final String JSON_PROPERTY_LABEL = "label";
    @JsonProperty(value="label")
    private String label;
    public static final String JSON_PROPERTY_TYPE = "type";
    @JsonProperty(value="type")
    private String type;
    public static final String JSON_PROPERTY_VALUE = "value";
    @JsonProperty(value="value")
    private List<String> value = new ArrayList();

    public AlgorithmParameter id(BigDecimal id) {
        this.id = id;
        return this;
    }

    @JsonProperty(value="id")
    @ApiModelProperty(value="The job's algorithms parameter id.")
    @Valid
    public BigDecimal getId() {
        return this.id;
    }

    public void setId(BigDecimal id) {
        this.id = id;
    }

    public AlgorithmParameter parameterId(String parameterId) {
        this.parameterId = parameterId;
        return this;
    }

    @JsonProperty(value="parameterId")
    @ApiModelProperty(value="The parameter identifier.")
    public String getParameterId() {
        return this.parameterId;
    }

    public void setParameterId(String parameterId) {
        this.parameterId = parameterId;
    }

    public AlgorithmParameter label(String label) {
        this.label = label;
        return this;
    }

    @JsonProperty(value="label")
    @ApiModelProperty(value="Parameter label.")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public AlgorithmParameter type(String type) {
        this.type = type;
        return this;
    }

    @JsonProperty(value="type")
    @ApiModelProperty(value="The type of the parameter.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public AlgorithmParameter value(List<String> value) {
        this.value = value;
        return this;
    }

    public AlgorithmParameter addValueItem(String valueItem) {
        if (this.value == null) {
            this.value = new ArrayList();
        }
        this.value.add(valueItem);
        return this;
    }

    @JsonProperty(value="value")
    @ApiModelProperty(value="")
    public List<String> getValue() {
        return this.value;
    }

    public void setValue(List<String> value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlgorithmParameter algorithmParameter = (AlgorithmParameter)o;
        return Objects.equals(this.id, algorithmParameter.id) && Objects.equals(this.parameterId, algorithmParameter.parameterId) && Objects.equals(this.label, algorithmParameter.label) && Objects.equals(this.type, algorithmParameter.type) && Objects.equals(this.value, algorithmParameter.value);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.parameterId, this.label, this.type, this.value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AlgorithmParameter {\n");
        sb.append("    id: ").append(this.toIndentedString((Object)this.id)).append("\n");
        sb.append("    parameterId: ").append(this.toIndentedString((Object)this.parameterId)).append("\n");
        sb.append("    label: ").append(this.toIndentedString((Object)this.label)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    value: ").append(this.toIndentedString((Object)this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

