/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.job.application.controller;

import br.pucrio.tecgraf.soma.job.api.JobsApi;
import br.pucrio.tecgraf.soma.job.api.model.Algorithm;
import br.pucrio.tecgraf.soma.job.api.model.AlgorithmResponse;
import br.pucrio.tecgraf.soma.job.api.model.JobData;
import br.pucrio.tecgraf.soma.job.api.model.JobPagination;
import br.pucrio.tecgraf.soma.job.api.model.JobResponse;
import br.pucrio.tecgraf.soma.job.api.model.NewComment;
import br.pucrio.tecgraf.soma.job.application.appservice.JobAppService;
import br.pucrio.tecgraf.soma.job.domain.dto.DomainMapper;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.ServiceUnavailableException;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.SecurityContext;
import java.util.Arrays;
import java.util.List;
import org.jboss.logging.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Component;

@Component
public class JobController
extends JobsApi {
    private static final Logger LOG = Logger.getLogger(JobController.class);
    @Value(value="${job.history.search.limit.results.enable}")
    public boolean enableMaxResultsProperty;
    @Value(value="${job.history.search.limit.results.max}")
    public int maxResultsPropertyValue;
    @Autowired
    private JobAppService jobAppService;
    @Autowired
    private HttpServletRequest request;

    public JobController() {
        super(null);
    }

    public Response jobsHistoryAlgorithmsGet(String q, String locale, SecurityContext securityContext) throws ServiceUnavailableException {
        AlgorithmResponse response = new AlgorithmResponse();
        response.setProcessingDate(Long.valueOf(System.currentTimeMillis()));
        String accessToken = this.request.getHeader("Authorization");
        if (accessToken == null || accessToken.isEmpty()) {
            return Response.status((int)HttpStatus.UNAUTHORIZED.value()).build();
        }
        response.setAlgorithms(Arrays.asList((Algorithm[])DomainMapper.convert((Object)this.jobAppService.findDistinctAlgorithms(q), Algorithm[].class)));
        return Response.ok().entity((Object)response).build();
    }

    public Response jobsHistoryJobIdCommentPut(String jobId, NewComment requestBody, String locale, SecurityContext securityContext) {
        String accessToken = this.request.getHeader("Authorization");
        if (accessToken == null || accessToken.isEmpty()) {
            LOG.info((Object)"Empty or null token");
            return Response.status((int)HttpStatus.UNAUTHORIZED.value()).build();
        }
        if (requestBody == null || requestBody.getNewComment() == null) {
            String errorMsg = "Missing body with newComment parameter";
            LOG.info((Object)errorMsg);
            return Response.status((int)HttpStatus.BAD_REQUEST.value(), (String)errorMsg).build();
        }
        this.jobAppService.editJobComment(jobId, requestBody.getNewComment());
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response jobsHistoryDelete(List<String> jobIds, String locale, SecurityContext securityContext) {
        this.jobAppService.markJobsAsDeleted(jobIds);
        return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
    }

    public Response jobsHistoryGet(String q, Integer offset, Integer limit, Boolean asc, String attr, Boolean grouped, String locale, SecurityContext securityContext) {
        String accessToken;
        int maxResults = this.enableMaxResultsProperty ? this.maxResultsPropertyValue : Integer.MAX_VALUE;
        if (limit == null) {
            limit = maxResults;
        } else if (limit <= 0 || limit > maxResults) {
            String msg = "Invalid limit value";
            LOG.info((Object)msg);
            return Response.status((int)HttpStatus.BAD_REQUEST.value(), (String)msg).build();
        }
        if (offset == null) {
            offset = 0;
        } else if (offset < 0) {
            String msg = "Offset must be a positive number or zero";
            LOG.info((Object)msg);
            return Response.status((int)HttpStatus.BAD_REQUEST.value(), (String)msg).build();
        }
        if (asc == null) {
            asc = false;
        }
        if ((accessToken = this.request.getHeader("Authorization")) == null || accessToken.isEmpty()) {
            LOG.info((Object)"Empty or null token");
            return Response.status((int)HttpStatus.UNAUTHORIZED.value()).build();
        }
        JobData data = new JobData();
        data.processingDate(Long.valueOf(System.currentTimeMillis()));
        JobPagination pagination = new JobPagination();
        pagination.setLimit(limit);
        JobResponse response = new JobResponse();
        response.data(data);
        response.pagination(pagination);
        if (grouped.booleanValue()) {
            this.jobAppService.findGroupedJobs(q, limit.intValue(), offset.intValue(), asc.booleanValue(), attr, response);
        } else {
            this.jobAppService.findJobs(q, limit.intValue(), offset.intValue(), asc.booleanValue(), attr, response);
        }
        return Response.ok().entity((Object)response).build();
    }
}

