package br.pucrio.tecgraf.soma.job.infrastructure.persistence.repository;


import jakarta.persistence.EntityManager;
import jakarta.persistence.NoResultException;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.TypedQuery;

import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import br.pucrio.tecgraf.soma.job.domain.model.Replica;
import br.pucrio.tecgraf.soma.job.domain.model.ReplicaJob;
import br.pucrio.tecgraf.soma.serviceapi.persistence.repository.impl.JPARepository;

@Transactional
@Repository
public class ReplicaRepository extends JPARepository<Replica> {
    @PersistenceContext private EntityManager _entityManager;

    @Override
    public Class<Replica> getType() {
        return Replica.class;
    }

    @Override
    public EntityManager getEntityManager() {
        return _entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this._entityManager = entityManager;
    }

    public void clearEntityManager() {
        this._entityManager.clear();
    }

    public Replica findBy(long multiflowId, int lineNumber) {
        EntityManager manager = getEntityManager();

        String hql = "SELECT r FROM Replica r WHERE r.multiflow.id = :multiflowId AND r.lineNumber = :lineNumber";
        TypedQuery<Replica> query = manager.createQuery(hql, Replica.class);
        query.setParameter("multiflowId", multiflowId);
        query.setParameter("lineNumber", lineNumber);


        try {
            return query.getSingleResult();
        } catch (NoResultException e) {
            return null;
        }
    }

    public ReplicaJob findReplicaJobBy(String replicaJobId) {
        EntityManager manager = getEntityManager();

        String hql = "SELECT rj FROM ReplicaJob rj WHERE rj.jobStringId = :replicaJobId";
        TypedQuery<ReplicaJob> query = manager.createQuery(hql, ReplicaJob.class);
        query.setParameter("replicaJobId", replicaJobId);

        try {
            return query.getSingleResult();
        } catch (NoResultException e) {
            return null;
        }
    }

    @Transactional
    public Integer getNextReplicaJobVersion(Replica replica) {
        EntityManager manager = getEntityManager();

        String hql = "SELECT COUNT(rj) FROM ReplicaJob rj WHERE rj.replica.id = :replicaId";
        TypedQuery<Long> query = manager.createQuery(hql, Long.class);
        query.setParameter("replicaId", replica.getId());

        try {
            return query.getSingleResult().intValue() + 1;
        } catch (NoResultException e) {
            return null;
        }        
    }

}
