/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.logservice.service;

import br.pucrio.tecgraf.soma.logservice.service.FileChunk;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class FileDataRead {
    Long fileLength;
    Charset fileCharset;
    List<FileChunk> chunks;

    public FileDataRead(Charset fileCharset, Long fileLength) {
        this.fileLength = fileLength;
        this.fileCharset = fileCharset;
        this.chunks = new ArrayList<FileChunk>();
    }

    public String getFileEncoding() {
        return this.fileCharset.displayName();
    }

    public Long getFileLength() {
        return this.fileLength;
    }

    public List<FileChunk> getChunks() {
        return this.chunks;
    }

    public void splitIntoChunks(Long fileOffset, Integer length, byte[] buffer, Integer chunkLength) {
        if (buffer.length == 0) {
            this.chunks.add(new FileChunk(fileOffset, 0, ""));
        } else {
            int dataOffset = 0;
            while (dataOffset < buffer.length && length > 0) {
                if (this.fileCharset == StandardCharsets.UTF_8) {
                    dataOffset = this.skipPartialUtf8(buffer, dataOffset);
                }
                int endOffset = Math.min(dataOffset + Math.min(chunkLength, length), buffer.length);
                if (this.fileCharset == StandardCharsets.UTF_8) {
                    endOffset = this.skipPartialUtf8(buffer, endOffset);
                }
                byte[] chunkData = Arrays.copyOfRange(buffer, dataOffset, endOffset);
                this.chunks.add(new FileChunk(fileOffset + (long)dataOffset, chunkData.length, new String(chunkData, this.fileCharset)));
                dataOffset = endOffset;
                length = length - chunkData.length;
            }
        }
    }

    private int skipPartialUtf8(byte[] buffer, int pos) {
        while (pos < buffer.length && (buffer[pos] & 0xFFFFFFC0) == -128) {
            ++pos;
        }
        return pos;
    }
}

