/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.logservice.service;

import br.pucrio.tecgraf.soma.logservice.contoller.JobLogController;
import br.pucrio.tecgraf.soma.logservice.service.FileDataRead;
import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import io.quarkus.runtime.configuration.CharsetConverter;
import io.smallrye.config.WithConverter;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.jboss.logging.Logger;

@ApplicationScoped
public class JobLogService {
    private static final Logger LOG = Logger.getLogger(JobLogController.class);
    @ConfigProperty(name="application.basedir")
    public String baseDir;
    @ConfigProperty(name="application.logsdir.pattern")
    public String logsDirPattern;
    @ConfigProperty(name="application.charset.detection.enable")
    public boolean charsetDetectionEnable;
    @ConfigProperty(name="application.charset.default")
    public @WithConverter(value=CharsetConverter.class) Charset defaultCharset;

    public boolean fileExistsAndIsReadable(String fileName, String jobIdFixed, String projectId) {
        File file = this.getFile(fileName, jobIdFixed, projectId);
        return file.exists() && file.isFile() && file.canRead();
    }

    public FileDataRead readFile(String fileName, String jobIdFixed, String projectId, Charset forcedCharset, Long offset, Integer length, Integer chunkLength) throws IOException {
        LOG.debugf("Reading file [%s, %s, %s] with parameters [offset=%d, length=%d, chunkLength=%d, forcedCharset=%s]", new Object[]{projectId, jobIdFixed, fileName, offset, length, chunkLength, forcedCharset});
        File file = this.getFile(fileName, jobIdFixed, projectId);
        Charset charset = this.guessCharset(file, forcedCharset);
        int extraBytes = charset == StandardCharsets.UTF_8 ? 6 : 0;
        long fileLength = file.length();
        long adjustedOffset = this.adjustOffset(offset, length, fileLength);
        int adjustedLength = this.adjustLength(adjustedOffset, length + extraBytes, fileLength);
        if (adjustedLength == 0) {
            FileDataRead fileDataRead = new FileDataRead(charset, fileLength);
            fileDataRead.splitIntoChunks(adjustedOffset, length, new byte[0], chunkLength);
            return fileDataRead;
        }
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            byte[] buffer = new byte[adjustedLength];
            raf.seek(adjustedOffset);
            int bytesRead = raf.read(buffer);
            LOG.debugf("Bytes read from file [%s, %s, %s]: %d", new Object[]{projectId, jobIdFixed, fileName, bytesRead});
            if (bytesRead < buffer.length) {
                LOG.fatalf("File [%s, %s, %s] shrank from %d bytes, reading from offset %d got only %d bytes", new Object[]{projectId, jobIdFixed, fileName, fileLength, adjustedOffset, bytesRead});
                throw new IOException("log file shrank");
            }
            FileDataRead fileDataRead = new FileDataRead(charset, fileLength);
            fileDataRead.splitIntoChunks(adjustedOffset, length, buffer, chunkLength);
            FileDataRead fileDataRead2 = fileDataRead;
            return fileDataRead2;
        }
    }

    public String getFileName(String fileName, String jobIdFixed, String projectId) {
        return this.getFilePath(fileName, jobIdFixed, projectId).toAbsolutePath().getFileName().toString();
    }

    public InputStream getFileAsStream(String fileName, String jobIdFixed, String projectId) throws FileNotFoundException {
        File file = this.getFile(fileName, jobIdFixed, projectId);
        LOG.debugf("Getting FileInputStream from path: %s", (Object)file.getAbsolutePath());
        return new FileInputStream(file);
    }

    public long getFileLength(String fileName, String jobIdFixed, String projectId) throws FileNotFoundException {
        return this.getFile(fileName, jobIdFixed, projectId).length();
    }

    private String getLogsDirPath(String jobId, String projectId) {
        String logsDirPath = this.logsDirPattern;
        logsDirPath = logsDirPath.replaceAll("__ROOT__", this.baseDir);
        logsDirPath = logsDirPath.replaceAll("__PROJECT__", projectId);
        logsDirPath = logsDirPath.replaceAll("__JOB__", jobId);
        return logsDirPath;
    }

    private Path getFilePath(String fileName, String jobIdFixed, String projectId) {
        return Path.of(this.getLogsDirPath(jobIdFixed, projectId), fileName).toAbsolutePath();
    }

    private File getFile(String fileName, String jobIdFixed, String projectId) {
        return this.getFilePath(fileName, jobIdFixed, projectId).toFile();
    }

    private long adjustOffset(Long offset, Integer length, Long fileLength) {
        if (offset == null) {
            return Math.max(fileLength - (long)length.intValue(), 0L);
        }
        if (offset >= 0L) {
            return Math.min(fileLength, offset);
        }
        return Math.max(fileLength + offset, 0L);
    }

    private int adjustLength(long offset, int length, long fileLength) {
        return Math.min(length, Math.toIntExact(fileLength - offset));
    }

    private Charset guessCharset(File file, Charset forcedCharset) throws IOException {
        Charset charset = forcedCharset;
        if (forcedCharset != null) {
            LOG.debugf("Using charset %s requested by client for file %s.", (Object)charset, (Object)file.getAbsolutePath());
            return forcedCharset;
        }
        if (!this.charsetDetectionEnable) {
            charset = this.defaultCharset;
            LOG.debugf("Using charset %s for file %s. Auto-detection is disabled.", (Object)charset, (Object)file.getAbsolutePath());
            return charset;
        }
        try (BufferedInputStream bs = new BufferedInputStream(new FileInputStream(file));){
            CharsetDetector charsetDetector = new CharsetDetector();
            charsetDetector.setText((InputStream)bs);
            charsetDetector.enableInputFilter(true);
            CharsetMatch cm = charsetDetector.detect();
            if (cm == null) {
                Charset charset2 = this.defaultCharset;
                return charset2;
            }
            if (cm.getConfidence() > 80) {
                String UTF_8 = "UTF-8";
                String ISO_8859_1 = "ISO-8859-1";
                switch (cm.getName()) {
                    case "UTF-8": {
                        charset = StandardCharsets.UTF_8;
                        LOG.debugf("Guessed charset %s with confidence %d for file %s", (Object)charset, (Object)cm.getConfidence(), (Object)file.getAbsolutePath());
                        break;
                    }
                    case "ISO-8859-1": {
                        charset = StandardCharsets.ISO_8859_1;
                        LOG.debugf("Guessed charset %s with confidence %d for file %s", (Object)charset, (Object)cm.getConfidence(), (Object)file.getAbsolutePath());
                        break;
                    }
                    default: {
                        charset = this.defaultCharset;
                        LOG.debugf("Using default charset %s for file %s because the guessed charset was not UTF-8 nor ISO-8859-1 [guessed charset %s with confidence %d]", new Object[]{charset, file.getAbsolutePath(), cm.getName(), cm.getConfidence()});
                        break;
                    }
                }
            } else {
                charset = this.defaultCharset;
                LOG.debugf("Using default charset %s for file %s because the confidence was lower than 80 [guessed charset %s with confidence %d]", new Object[]{charset, file.getAbsolutePath(), cm.getName(), cm.getConfidence()});
            }
            Charset charset3 = charset;
            return charset3;
        }
    }
}

