/*
 * Decompiled with CFR 0.152.
 */
package br.pucrio.tecgraf.soma.websocketnotifier.application.configuration;

import br.pucrio.tecgraf.soma.websocketnotifier.application.configuration.Constants;
import br.pucrio.tecgraf.soma.websocketnotifier.application.service.SocketHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.config.annotation.EnableWebSocket;
import org.springframework.web.socket.config.annotation.WebSocketConfigurer;
import org.springframework.web.socket.config.annotation.WebSocketHandlerRegistry;

@Configuration
@EnableWebSocket
public class WebSocketConfig
implements WebSocketConfigurer {
    private SocketHandler socketHandler;

    @Autowired
    public WebSocketConfig(SocketHandler socketHandler) {
        this.socketHandler = socketHandler;
    }

    public void registerWebSocketHandlers(WebSocketHandlerRegistry registry) {
        String endpointUrl = Constants.Config.WEBSOCKET_ENDPOINT.option.getValueName();
        registry.addHandler((WebSocketHandler)this.getSocketHandler(), new String[]{endpointUrl}).setAllowedOrigins(new String[]{"*"});
    }

    @Bean
    public SocketHandler getSocketHandler() {
        if (this.socketHandler == null) {
            this.socketHandler = new SocketHandler();
        }
        return this.socketHandler;
    }
}

