/*
 * Decompiled with CFR 0.152.
 */
package ppg.lex;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import ppg.lex.Lexer;
import ppg.lex.Token;

public class LexTest {
    private static final String HEADER = "ppg [lexertest]: ";

    public static void main(String[] args) {
        FileInputStream fileInput;
        String filename = null;
        try {
            filename = args[0];
            fileInput = new FileInputStream(filename);
        }
        catch (FileNotFoundException e) {
            System.out.println("Error: " + filename + " is not found.");
            return;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("ppg [lexertest]: Error: No file name given.");
            return;
        }
        File f = new File(filename);
        String simpleName = f.getName();
        Lexer lex = new Lexer(fileInput, simpleName);
        Token t = null;
        try {
            while (true) {
                t = lex.getToken();
                t.unparse(System.out);
                if (t.getCode() == 0) break;
                System.out.println();
            }
            fileInput.close();
        }
        catch (Error e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.exit(1);
        }
    }
}

