/*
 * Decompiled with CFR 0.152.
 */
package soot;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FoundFile {
    private static final Logger logger = LoggerFactory.getLogger(FoundFile.class);
    protected File file;
    protected String entryName;
    protected ZipFile zipFile;
    protected ZipEntry zipEntry;
    protected List<InputStream> openedInputStreams = new ArrayList<InputStream>();

    public FoundFile(ZipFile file, ZipEntry entry) {
        this();
        if (file == null || entry == null) {
            throw new IllegalArgumentException("Error: The archive and entry cannot be null.");
        }
        this.zipFile = file;
        this.zipEntry = entry;
    }

    public FoundFile(String archivePath, String entryName) {
        this();
        if (archivePath == null || entryName == null) {
            throw new IllegalArgumentException("Error: The archive path and entry name cannot be null.");
        }
        this.file = new File(archivePath);
        this.entryName = entryName;
    }

    public FoundFile(File file) {
        this();
        if (file == null) {
            throw new IllegalArgumentException("Error: The file cannot be null.");
        }
        this.file = file;
        this.entryName = null;
    }

    private FoundFile() {
    }

    public String getFilePath() {
        return this.file.getPath();
    }

    public boolean isZipFile() {
        return this.entryName != null;
    }

    public File getFile() {
        return this.file;
    }

    public InputStream inputStream() {
        InputStream ret = null;
        if (!this.isZipFile()) {
            try {
                ret = new FileInputStream(this.file);
            }
            catch (Exception e) {
                throw new RuntimeException("Error: Failed to open a InputStream for the file at path '" + this.file.getPath() + "'.", e);
            }
        }
        if (this.zipFile == null) {
            try {
                this.zipFile = new ZipFile(this.file);
                this.zipEntry = this.zipFile.getEntry(this.entryName);
                if (this.zipEntry == null) {
                    this.silentClose();
                    throw new RuntimeException("Error: Failed to find entry '" + this.entryName + "' in the archive file at path '" + this.file.getPath() + "'.");
                }
            }
            catch (Exception e) {
                this.silentClose();
                throw new RuntimeException("Error: Failed to open the archive file at path '" + this.file.getPath() + "' for entry '" + this.entryName + "'.", e);
            }
        }
        InputStream stream = null;
        try {
            stream = this.zipFile.getInputStream(this.zipEntry);
            ret = this.doJDKBugWorkaround(stream, this.zipEntry.getSize());
        }
        catch (Exception e) {
            throw new RuntimeException("Error: Failed to open a InputStream for the entry '" + this.zipEntry.getName() + "' of the archive at path '" + this.zipFile.getName() + "'.", e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        this.openedInputStreams.add(ret);
        return ret;
    }

    public void silentClose() {
        try {
            this.close();
        }
        catch (Exception e) {
            logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList<Exception> errs = new ArrayList<Exception>(0);
        for (InputStream is : this.openedInputStreams) {
            try {
                is.close();
            }
            catch (Exception e) {
                errs.add(e);
            }
        }
        this.openedInputStreams.clear();
        this.closeZipFile(errs);
        if (!errs.isEmpty()) {
            String msg = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (PrintStream ps = null;){
                ps = new PrintStream((OutputStream)baos, true, "utf-8");
                ps.println("Error: Failed to close all opened resources. The following exceptions were thrown in the process: ");
                int i = 0;
                for (Throwable throwable : errs) {
                    ps.print("Exception ");
                    ps.print(i++);
                    ps.print(": ");
                    logger.error(throwable.getMessage(), throwable);
                }
                msg = new String(baos.toByteArray(), StandardCharsets.UTF_8);
            }
            throw new RuntimeException(msg);
        }
    }

    protected void closeZipFile(List<Exception> errs) {
        if (this.zipFile != null) {
            try {
                this.zipFile.close();
                errs.clear();
            }
            catch (Exception e) {
                errs.add(e);
            }
            this.zipFile = null;
            this.zipEntry = null;
        }
    }

    private InputStream doJDKBugWorkaround(InputStream is, long size) throws IOException {
        int sz;
        byte[] buf = new byte[sz];
        int N = 1024;
        int ln = 0;
        int count = 0;
        for (sz = (int)size; sz > 0 && (ln = is.read(buf, count, Math.min(1024, sz))) != -1; sz -= ln) {
            count += ln;
        }
        return new ByteArrayInputStream(buf);
    }
}

