/*
 * Decompiled with CFR 0.152.
 */
package soot.asm;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootResolver;
import soot.Type;
import soot.asm.AsmUtil;
import soot.asm.FieldBuilder;
import soot.asm.MethodBuilder;
import soot.asm.TagBuilder;
import soot.tagkit.ConstantValueTag;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.EnclosingMethodTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.InnerClassTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LongConstantValueTag;
import soot.tagkit.SignatureTag;
import soot.tagkit.SourceFileTag;
import soot.tagkit.StringConstantValueTag;

public class SootClassBuilder
extends ClassVisitor {
    protected TagBuilder tb;
    protected final SootClass klass;
    protected final Set<Type> deps;

    protected SootClassBuilder(SootClass klass) {
        super(327680);
        this.klass = klass;
        this.deps = new HashSet<Type>();
    }

    private TagBuilder getTagBuilder() {
        TagBuilder t = this.tb;
        if (t == null) {
            t = this.tb = new TagBuilder(this.klass, this);
        }
        return t;
    }

    void addDep(String s) {
        this.addDep(RefType.v(AsmUtil.baseTypeName(s)));
    }

    void addDep(Type s) {
        this.deps.add(s);
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        if (!(name = AsmUtil.toQualifiedName(name)).equals(this.klass.getName())) {
            throw new RuntimeException("Class names not equal! " + name + " != " + this.klass.getName());
        }
        this.klass.setModifiers(access & 0xFFFFFFDF);
        if (superName != null) {
            superName = AsmUtil.toQualifiedName(superName);
            this.addDep(RefType.v(superName));
            this.klass.setSuperclass(SootResolver.v().makeClassRef(superName));
        }
        for (String intrf : interfaces) {
            intrf = AsmUtil.toQualifiedName(intrf);
            this.addDep(RefType.v(intrf));
            SootClass interfaceClass = SootResolver.v().makeClassRef(intrf);
            interfaceClass.setModifiers(interfaceClass.getModifiers() | 0x200);
            this.klass.addInterface(interfaceClass);
        }
        if (signature != null) {
            this.klass.addTag(new SignatureTag(signature));
        }
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        Type type = AsmUtil.toJimpleType(desc);
        this.addDep(type);
        SootField field = Scene.v().makeSootField(name, type, access);
        ConstantValueTag tag = value instanceof Integer ? new IntegerConstantValueTag((Integer)value) : (value instanceof Float ? new FloatConstantValueTag(((Float)value).floatValue()) : (value instanceof Long ? new LongConstantValueTag((Long)value) : (value instanceof Double ? new DoubleConstantValueTag((Double)value) : (value instanceof String ? new StringConstantValueTag(value.toString()) : null))));
        if (tag != null) {
            field.addTag(tag);
        }
        if (signature != null) {
            field.addTag(new SignatureTag(signature));
        }
        field = this.klass.getOrAddField(field);
        return new FieldBuilder(field, this);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        List<SootClass> thrownExceptions;
        if (exceptions == null || exceptions.length == 0) {
            thrownExceptions = Collections.emptyList();
        } else {
            int len = exceptions.length;
            thrownExceptions = new ArrayList(len);
            for (int i = 0; i != len; ++i) {
                String ex = AsmUtil.toQualifiedName(exceptions[i]);
                this.addDep(RefType.v(ex));
                thrownExceptions.add(SootResolver.v().makeClassRef(ex));
            }
        }
        List<Type> sigTypes = AsmUtil.toJimpleDesc(desc);
        for (Type type : sigTypes) {
            this.addDep(type);
        }
        SootMethod method = Scene.v().makeSootMethod(name, sigTypes, sigTypes.remove(sigTypes.size() - 1), access, thrownExceptions);
        if (signature != null) {
            method.addTag(new SignatureTag(signature));
        }
        method = this.klass.getOrAddMethod(method);
        return new MethodBuilder(method, this, desc, exceptions);
    }

    public void visitSource(String source, String debug) {
        if (source != null) {
            this.klass.addTag(new SourceFileTag(source));
        }
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.klass.addTag(new InnerClassTag(name, outerName, innerName, access));
        String innerClassname = AsmUtil.toQualifiedName(name);
        this.deps.add(RefType.v(innerClassname));
    }

    public void visitOuterClass(String owner, String name, String desc) {
        if (name != null) {
            this.klass.addTag(new EnclosingMethodTag(owner, name, desc));
        }
        owner = AsmUtil.toQualifiedName(owner);
        this.deps.add(RefType.v(owner));
        this.klass.setOuterClass(SootResolver.v().makeClassRef(owner));
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return this.getTagBuilder().visitAnnotation(desc, visible);
    }

    public void visitAttribute(Attribute attr) {
        this.getTagBuilder().visitAttribute(attr);
    }
}

