/*
 * Decompiled with CFR 0.152.
 */
package soot.baf.internal;

import soot.DoubleType;
import soot.LongType;
import soot.Type;
import soot.baf.Baf;
import soot.baf.InstSwitch;
import soot.baf.SwapInst;
import soot.baf.internal.AbstractInst;
import soot.util.Switch;

public class BSwapInst
extends AbstractInst
implements SwapInst {
    protected Type mFromType;
    protected Type mToType;

    public BSwapInst(Type fromType, Type toType) {
        if (fromType instanceof LongType || fromType instanceof DoubleType) {
            throw new RuntimeException("fromType is LongType or DoubleType !");
        }
        if (toType instanceof LongType || toType instanceof DoubleType) {
            throw new RuntimeException("toType is LongType or DoubleType !");
        }
        this.mFromType = Baf.getDescriptorTypeOf(fromType);
        this.mToType = Baf.getDescriptorTypeOf(toType);
    }

    @Override
    public Type getFromType() {
        return this.mFromType;
    }

    @Override
    public void setFromType(Type fromType) {
        this.mFromType = fromType;
    }

    @Override
    public Type getToType() {
        return this.mToType;
    }

    @Override
    public void setToType(Type toType) {
        this.mToType = toType;
    }

    @Override
    public int getInCount() {
        return 2;
    }

    @Override
    public int getInMachineCount() {
        return 2;
    }

    @Override
    public int getOutCount() {
        return 2;
    }

    @Override
    public int getOutMachineCount() {
        return 2;
    }

    @Override
    public void apply(Switch sw) {
        ((InstSwitch)sw).caseSwapInst(this);
    }

    @Override
    public String toString() {
        return "swap." + Baf.bafDescriptorOf(this.mFromType) + Baf.bafDescriptorOf(this.mToType);
    }

    @Override
    public String getName() {
        return "swap";
    }
}

