/*
 * Decompiled with CFR 0.152.
 */
package soot.dava.toolkits.base.AST.transformations;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.G;
import soot.Local;
import soot.RefType;
import soot.SootClass;
import soot.dava.internal.AST.ASTIfElseNode;
import soot.dava.internal.AST.ASTIfNode;
import soot.dava.internal.AST.ASTLabeledBlockNode;
import soot.dava.internal.AST.ASTNode;
import soot.dava.internal.AST.ASTStatementSequenceNode;
import soot.dava.internal.AST.ASTSwitchNode;
import soot.dava.internal.AST.ASTTryNode;
import soot.dava.internal.SET.SETNodeLabel;
import soot.dava.toolkits.base.AST.analysis.DepthFirstAdapter;
import soot.dava.toolkits.base.AST.transformations.EmptyElseRemover;
import soot.dava.toolkits.base.AST.transformations.OrAggregatorThree;
import soot.dava.toolkits.base.AST.transformations.UselessLabeledBlockRemover;

public class ASTCleaner
extends DepthFirstAdapter {
    public ASTCleaner() {
    }

    public ASTCleaner(boolean verbose) {
        super(verbose);
    }

    @Override
    public void caseASTStatementSequenceNode(ASTStatementSequenceNode node) {
    }

    @Override
    public void normalRetrieving(ASTNode node) {
        if (node instanceof ASTSwitchNode) {
            this.dealWithSwitchNode((ASTSwitchNode)node);
            return;
        }
        Iterator<Object> sbit = node.get_SubBodies().iterator();
        int subBodyNumber = 0;
        while (sbit.hasNext()) {
            Object subBody = sbit.next();
            Iterator it = ((List)subBody).iterator();
            int nodeNumber = 0;
            while (it.hasNext()) {
                ASTNode nextNode;
                ASTNode temp = (ASTNode)it.next();
                if (temp instanceof ASTLabeledBlockNode) {
                    ASTLabeledBlockNode labelBlock = (ASTLabeledBlockNode)temp;
                    SETNodeLabel label = labelBlock.get_Label();
                    if (label.toString() == null) {
                        UselessLabeledBlockRemover.removeLabeledBlock(node, labelBlock, subBodyNumber, nodeNumber);
                        if (G.v().ASTTransformations_modified) {
                            return;
                        }
                    }
                } else if (temp instanceof ASTIfElseNode) {
                    List<Object> elseBody = ((ASTIfElseNode)temp).getElseBody();
                    if (elseBody.size() == 0) {
                        EmptyElseRemover.removeElseBody(node, (ASTIfElseNode)temp, subBodyNumber, nodeNumber);
                    }
                } else if (temp instanceof ASTIfNode && it.hasNext() && (nextNode = (ASTNode)((List)subBody).get(nodeNumber + 1)) instanceof ASTIfNode) {
                    OrAggregatorThree.checkAndTransform(node, (ASTIfNode)temp, (ASTIfNode)nextNode, nodeNumber, subBodyNumber);
                    if (G.v().ASTTransformations_modified) {
                        return;
                    }
                }
                temp.apply(this);
                ++nodeNumber;
            }
            ++subBodyNumber;
        }
    }

    @Override
    public void caseASTTryNode(ASTTryNode node) {
        this.inASTTryNode(node);
        List<Object> tryBody = node.get_TryBody();
        Iterator<Object> it = tryBody.iterator();
        int nodeNumber = 0;
        while (it.hasNext()) {
            ASTNode nextNode;
            List<Object> newBody;
            ASTNode temp = (ASTNode)it.next();
            if (temp instanceof ASTLabeledBlockNode) {
                List<Object> newBody2;
                ASTLabeledBlockNode labelBlock = (ASTLabeledBlockNode)temp;
                SETNodeLabel label = labelBlock.get_Label();
                if (label.toString() == null && (newBody2 = UselessLabeledBlockRemover.createNewSubBody(tryBody, nodeNumber, labelBlock)) != null) {
                    node.replaceTryBody(newBody2);
                    G.v().ASTTransformations_modified = true;
                }
            } else if (temp instanceof ASTIfElseNode) {
                List<Object> elseBody = ((ASTIfElseNode)temp).getElseBody();
                if (elseBody.size() == 0 && (newBody = EmptyElseRemover.createNewNodeBody(tryBody, nodeNumber, (ASTIfElseNode)temp)) != null) {
                    node.replaceTryBody(newBody);
                    G.v().ASTTransformations_modified = true;
                    return;
                }
            } else if (temp instanceof ASTIfNode && it.hasNext() && (nextNode = (ASTNode)tryBody.get(nodeNumber + 1)) instanceof ASTIfNode && (newBody = OrAggregatorThree.createNewNodeBody(tryBody, nodeNumber, (ASTIfNode)temp, (ASTIfNode)nextNode)) != null) {
                node.replaceTryBody(newBody);
                G.v().ASTTransformations_modified = true;
                return;
            }
            temp.apply(this);
            ++nodeNumber;
        }
        Map<Object, Object> exceptionMap = node.get_ExceptionMap();
        Map<Object, Object> paramMap = node.get_ParamMap();
        List<Object> catchList = node.get_CatchList();
        Iterator itBody = null;
        for (ASTTryNode.container container2 : catchList) {
            SootClass sootClass = (SootClass)exceptionMap.get(container2);
            RefType type = sootClass.getType();
            this.caseType(type);
            Local local = (Local)paramMap.get(container2);
            this.decideCaseExprOrRef(local);
            List body = (List)container2.o;
            itBody = body.iterator();
            nodeNumber = 0;
            while (itBody.hasNext()) {
                ASTNode nextNode;
                List<Object> newBody;
                ASTNode temp = (ASTNode)itBody.next();
                if (temp instanceof ASTLabeledBlockNode) {
                    List<Object> newBody3;
                    ASTLabeledBlockNode labelBlock = (ASTLabeledBlockNode)temp;
                    SETNodeLabel label = labelBlock.get_Label();
                    if (label.toString() == null && (newBody3 = UselessLabeledBlockRemover.createNewSubBody(body, nodeNumber, labelBlock)) != null) {
                        container2.replaceBody(newBody3);
                        G.v().ASTTransformations_modified = true;
                    }
                } else if (temp instanceof ASTIfElseNode) {
                    List<Object> elseBody = ((ASTIfElseNode)temp).getElseBody();
                    if (elseBody.size() == 0 && (newBody = EmptyElseRemover.createNewNodeBody(body, nodeNumber, (ASTIfElseNode)temp)) != null) {
                        container2.replaceBody(newBody);
                        G.v().ASTTransformations_modified = true;
                        return;
                    }
                } else if (temp instanceof ASTIfNode && itBody.hasNext() && (nextNode = (ASTNode)body.get(nodeNumber + 1)) instanceof ASTIfNode && (newBody = OrAggregatorThree.createNewNodeBody(body, nodeNumber, (ASTIfNode)temp, (ASTIfNode)nextNode)) != null) {
                    container2.replaceBody(newBody);
                    G.v().ASTTransformations_modified = true;
                    return;
                }
                temp.apply(this);
                ++nodeNumber;
            }
        }
        this.outASTTryNode(node);
    }

    private void dealWithSwitchNode(ASTSwitchNode node) {
        List<Object> indexList = node.getIndexList();
        Map<Object, List<Object>> index2BodyList = node.getIndex2BodyList();
        for (Object currentIndex : indexList) {
            List<Object> body = index2BodyList.get(currentIndex);
            if (body == null) continue;
            Iterator<Object> itBody = body.iterator();
            int nodeNumber = 0;
            while (itBody.hasNext()) {
                ASTNode nextNode;
                List<Object> newBody;
                ASTNode temp = (ASTNode)itBody.next();
                if (temp instanceof ASTLabeledBlockNode) {
                    List<Object> newBody2;
                    ASTLabeledBlockNode labelBlock = (ASTLabeledBlockNode)temp;
                    SETNodeLabel label = labelBlock.get_Label();
                    if (label.toString() == null && (newBody2 = UselessLabeledBlockRemover.createNewSubBody(body, nodeNumber, labelBlock)) != null) {
                        index2BodyList.put(currentIndex, newBody2);
                        node.replaceIndex2BodyList(index2BodyList);
                        G.v().ASTTransformations_modified = true;
                    }
                } else if (temp instanceof ASTIfElseNode) {
                    List<Object> elseBody = ((ASTIfElseNode)temp).getElseBody();
                    if (elseBody.size() == 0 && (newBody = EmptyElseRemover.createNewNodeBody(body, nodeNumber, (ASTIfElseNode)temp)) != null) {
                        index2BodyList.put(currentIndex, newBody);
                        node.replaceIndex2BodyList(index2BodyList);
                        G.v().ASTTransformations_modified = true;
                        return;
                    }
                } else if (temp instanceof ASTIfNode && itBody.hasNext() && (nextNode = (ASTNode)body.get(nodeNumber + 1)) instanceof ASTIfNode && (newBody = OrAggregatorThree.createNewNodeBody(body, nodeNumber, (ASTIfNode)temp, (ASTIfNode)nextNode)) != null) {
                    index2BodyList.put(currentIndex, newBody);
                    node.replaceIndex2BodyList(index2BodyList);
                    G.v().ASTTransformations_modified = true;
                    return;
                }
                temp.apply(this);
                ++nodeNumber;
            }
        }
    }
}

