/*
 * Decompiled with CFR 0.152.
 */
package soot.dexpler;

import java.util.Iterator;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.DexFile;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.SootResolver;
import soot.dexpler.DexAnnotation;
import soot.dexpler.DexField;
import soot.dexpler.DexInnerClassParser;
import soot.dexpler.DexMethod;
import soot.dexpler.DexType;
import soot.dexpler.Util;
import soot.javaToJimple.IInitialResolver;
import soot.options.Options;
import soot.tagkit.InnerClassAttribute;
import soot.tagkit.InnerClassTag;
import soot.tagkit.SourceFileTag;
import soot.tagkit.Tag;

public class DexClassLoader {
    protected void loadMethod(Method method, SootClass declaringClass, DexAnnotation annotations, DexMethod dexMethodFactory) {
        SootMethod sm = dexMethodFactory.makeSootMethod(method);
        if (declaringClass.declaresMethod(sm.getName(), sm.getParameterTypes(), sm.getReturnType())) {
            return;
        }
        declaringClass.addMethod(sm);
        annotations.handleMethodAnnotation(sm, method);
    }

    public IInitialResolver.Dependencies makeSootClass(SootClass sc, ClassDef defItem, DexFile dexFile) {
        String superClass = defItem.getSuperclass();
        IInitialResolver.Dependencies deps = new IInitialResolver.Dependencies();
        String sourceFile = defItem.getSourceFile();
        if (sourceFile != null) {
            sc.addTag(new SourceFileTag(sourceFile));
        }
        if (superClass != null) {
            String superClassName = Util.dottedClassName(superClass);
            SootClass sootSuperClass = SootResolver.v().makeClassRef(superClassName);
            sc.setSuperclass(sootSuperClass);
            deps.typesToHierarchy.add(sootSuperClass.getType());
        }
        int accessFlags = defItem.getAccessFlags();
        sc.setModifiers(accessFlags);
        if (defItem.getInterfaces() != null) {
            for (Object interfaceName : defItem.getInterfaces()) {
                String interfaceClassName = Util.dottedClassName((String)interfaceName);
                if (sc.implementsInterface(interfaceClassName)) continue;
                SootClass interfaceClass = SootResolver.v().makeClassRef(interfaceClassName);
                interfaceClass.setModifiers(interfaceClass.getModifiers() | 0x200);
                sc.addInterface(interfaceClass);
                deps.typesToHierarchy.add(interfaceClass.getType());
            }
        }
        if (Options.v().oaat() && sc.resolvingLevel() <= 1) {
            return deps;
        }
        DexAnnotation da = this.createDexAnnotation(sc, deps);
        for (Field sf : defItem.getStaticFields()) {
            this.loadField(sc, da, sf);
        }
        for (Object f : defItem.getInstanceFields()) {
            this.loadField(sc, da, (Field)f);
        }
        DexMethod dexMethod = this.createDexMethodFactory(dexFile, sc);
        for (Method method : defItem.getDirectMethods()) {
            this.loadMethod(method, sc, da, dexMethod);
        }
        for (Method method : defItem.getVirtualMethods()) {
            this.loadMethod(method, sc, da, dexMethod);
        }
        da.handleClassAnnotation(defItem);
        InnerClassAttribute ica = (InnerClassAttribute)sc.getTag("InnerClassAttribute");
        if (ica != null) {
            Iterator<InnerClassTag> innerTagIt = ica.getSpecs().iterator();
            while (innerTagIt.hasNext()) {
                Tag t = innerTagIt.next();
                if (!(t instanceof InnerClassTag)) continue;
                InnerClassTag ict = (InnerClassTag)t;
                String outer = DexInnerClassParser.getOuterClassNameFromTag(ict);
                if (outer == null || outer.length() == 0) {
                    innerTagIt.remove();
                    continue;
                }
                if (outer.equals(sc.getName())) continue;
                String inner = ict.getInnerClass().replaceAll("/", ".");
                if (!inner.equals(sc.getName())) {
                    innerTagIt.remove();
                    continue;
                }
                SootClass osc = SootResolver.v().makeClassRef(outer);
                if (osc == sc) {
                    if (!sc.hasOuterClass()) continue;
                    osc = sc.getOuterClass();
                } else {
                    deps.typesToHierarchy.add(osc.getType());
                }
                InnerClassAttribute icat = (InnerClassAttribute)osc.getTag("InnerClassAttribute");
                if (icat == null) {
                    icat = new InnerClassAttribute();
                    osc.addTag(icat);
                }
                InnerClassTag newt = new InnerClassTag(ict.getInnerClass(), ict.getOuterClass(), ict.getShortName(), ict.getAccessFlags());
                icat.add(newt);
                innerTagIt.remove();
                if (sc.hasTag("InnerClassTag") || !((InnerClassTag)t).getInnerClass().replaceAll("/", ".").equals(sc.toString())) continue;
                sc.addTag(t);
            }
            if (ica.getSpecs().isEmpty()) {
                sc.getTags().remove(ica);
            }
        }
        return deps;
    }

    protected DexAnnotation createDexAnnotation(SootClass clazz, IInitialResolver.Dependencies deps) {
        return new DexAnnotation(clazz, deps);
    }

    protected DexMethod createDexMethodFactory(DexFile dexFile, SootClass sc) {
        return new DexMethod(dexFile, sc);
    }

    protected void loadField(SootClass declaringClass, DexAnnotation annotations, Field sf) {
        if (declaringClass.declaresField(sf.getName(), DexType.toSoot(sf.getType()))) {
            return;
        }
        SootField sootField = DexField.makeSootField(sf);
        sootField = declaringClass.getOrAddField(sootField);
        annotations.handleFieldAnnotation(sootField, sf);
    }
}

