/*
 * Decompiled with CFR 0.152.
 */
package soot.jbco.jimpleTransformations;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.Trap;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPatchingChain;
import soot.jbco.IJbcoTransform;
import soot.jbco.Main;
import soot.jbco.util.Rand;
import soot.jimple.GotoStmt;
import soot.jimple.IdentityStmt;
import soot.jimple.Jimple;
import soot.util.Chain;

public class GotoInstrumenter
extends BodyTransformer
implements IJbcoTransform {
    private static final Logger logger = LoggerFactory.getLogger(GotoInstrumenter.class);
    public static final String name = "jtp.jbco_gia";
    public static final String[] dependencies = new String[]{"jtp.jbco_gia"};
    private int trapsAdded = 0;
    private int gotosInstrumented = 0;
    private static final UnitBox[] EMPTY_UNIT_BOX_ARRAY = new UnitBox[0];
    private static final int MAX_TRIES_TO_GET_REORDER_COUNT = 10;

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String[] getDependencies() {
        return Arrays.copyOf(dependencies, dependencies.length);
    }

    @Override
    public void outputSummary() {
        logger.info("Instrumented {} GOTOs, added {} traps.", (Object)this.gotosInstrumented, (Object)this.trapsAdded);
    }

    @Override
    protected void internalTransform(Body body, String phaseName, Map<String, String> options) {
        Object firstReorderingUnit;
        int tries;
        Unit unit;
        if ("<init>".equals(body.getMethod().getName()) || "<clinit>".equals(body.getMethod().getName())) {
            if (this.isVerbose()) {
                logger.info("Skipping {} method GOTO instrumentation as it is constructor/initializer.", (Object)body.getMethod().getSignature());
            }
            return;
        }
        if (Main.getWeight(phaseName, body.getMethod().getSignature()) == 0) {
            return;
        }
        UnitPatchingChain units = body.getUnits();
        int precedingFirstNotIdentityIndex = 0;
        Unit precedingFirstNotIdentity = null;
        Iterator iterator = units.iterator();
        while (iterator.hasNext() && (unit = (Unit)iterator.next()) instanceof IdentityStmt) {
            precedingFirstNotIdentity = unit;
            ++precedingFirstNotIdentityIndex;
        }
        int unitsLeft = units.size() - precedingFirstNotIdentityIndex;
        if (unitsLeft < 8) {
            if (this.isVerbose()) {
                logger.info("Skipping {} method GOTO instrumentation as it is too small.", (Object)body.getMethod().getSignature());
            }
            return;
        }
        int unitsQuantityToReorder = 0;
        for (tries = 0; tries < 10; ++tries) {
            unitsQuantityToReorder = Rand.getInt(unitsLeft - 2) + 1;
            Unit selectedUnit = (Unit)Iterables.get((Iterable)units, (int)(precedingFirstNotIdentityIndex + unitsQuantityToReorder));
            if (GotoInstrumenter.isExceptionCaught(selectedUnit, units, body.getTraps())) continue;
        }
        if (tries >= 10) {
            return;
        }
        if (this.isVerbose()) {
            logger.info("Adding GOTOs to \"{}\".", (Object)body.getMethod().getName());
        }
        Object first = precedingFirstNotIdentity == null ? units.getFirst() : precedingFirstNotIdentity;
        Object reorderingUnit = firstReorderingUnit = units.getSuccOf(first);
        for (int reorder = 0; reorder < unitsQuantityToReorder; ++reorder) {
            UnitBox[] pointingToReorderingUnit;
            for (UnitBox element : pointingToReorderingUnit = reorderingUnit.getBoxesPointingToThis().toArray(EMPTY_UNIT_BOX_ARRAY)) {
                reorderingUnit.removeBoxPointingToThis(element);
            }
            Object nextReorderingUnit = units.getSuccOf(reorderingUnit);
            units.remove(reorderingUnit);
            units.add(reorderingUnit);
            for (UnitBox element : pointingToReorderingUnit) {
                reorderingUnit.addBoxPointingToThis(element);
            }
            reorderingUnit = nextReorderingUnit;
        }
        Object firstReorderingNotGotoStmt = first instanceof GotoStmt ? ((GotoStmt)first).getTargetBox().getUnit() : firstReorderingUnit;
        GotoStmt gotoFirstReorderingNotGotoStmt = Jimple.v().newGotoStmt((Unit)firstReorderingNotGotoStmt);
        units.insertBeforeNoRedirect(gotoFirstReorderingNotGotoStmt, reorderingUnit);
        if (units.getLast().fallsThrough()) {
            GotoStmt gotoStmt = reorderingUnit instanceof GotoStmt ? Jimple.v().newGotoStmt(((GotoStmt)reorderingUnit).getTargetBox().getUnit()) : Jimple.v().newGotoStmt((Unit)reorderingUnit);
            units.add(gotoStmt);
        }
        ++this.gotosInstrumented;
        Object secondReorderedUnit = units.getSuccOf(firstReorderingNotGotoStmt);
        if (secondReorderedUnit == null || secondReorderedUnit.equals(units.getLast()) && secondReorderedUnit instanceof IdentityStmt) {
            if (firstReorderingNotGotoStmt instanceof IdentityStmt) {
                if (this.isVerbose()) {
                    logger.info("Skipping adding try-catch block at \"{}\".", (Object)body.getMethod().getSignature());
                }
                return;
            }
            secondReorderedUnit = firstReorderingNotGotoStmt;
        }
        RefType throwable = Scene.v().getRefType("java.lang.Throwable");
        Local caughtExceptionLocal = Jimple.v().newLocal("jbco_gi_caughtExceptionLocal", throwable);
        body.getLocals().add(caughtExceptionLocal);
        IdentityStmt caughtExceptionHandler = Jimple.v().newIdentityStmt(caughtExceptionLocal, Jimple.v().newCaughtExceptionRef());
        units.add(caughtExceptionHandler);
        units.add(Jimple.v().newThrowStmt(caughtExceptionLocal));
        Iterator<IdentityStmt> reorderedUnitsIterator = units.iterator(secondReorderedUnit, units.getPredOf(caughtExceptionHandler));
        Unit trapEndUnit = reorderedUnitsIterator.next();
        while (trapEndUnit instanceof IdentityStmt && reorderedUnitsIterator.hasNext()) {
            trapEndUnit = reorderedUnitsIterator.next();
        }
        trapEndUnit = units.getSuccOf(trapEndUnit);
        body.getTraps().add(Jimple.v().newTrap(throwable.getSootClass(), (Unit)units.getPredOf(firstReorderingNotGotoStmt), trapEndUnit, caughtExceptionHandler));
        ++this.trapsAdded;
    }

    private static boolean isExceptionCaught(Unit unit, Chain<Unit> units, Chain<Trap> traps) {
        for (Trap trap : traps) {
            Unit end = trap.getEndUnit();
            if (end.equals(unit)) {
                return true;
            }
            Iterator<Unit> unitsInTryIterator = units.iterator(trap.getBeginUnit(), units.getPredOf(end));
            if (!Iterators.contains(unitsInTryIterator, (Object)unit)) continue;
            return true;
        }
        return false;
    }
}

