/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.internal;

import java.util.ArrayList;
import java.util.List;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Unit;
import soot.UnitPrinter;
import soot.Value;
import soot.ValueBox;
import soot.baf.Baf;
import soot.baf.DynamicInvokeInst;
import soot.jimple.ConvertToBaf;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.ExprSwitch;
import soot.jimple.Jimple;
import soot.jimple.JimpleToBafContext;
import soot.jimple.MethodHandle;
import soot.jimple.internal.AbstractInvokeExpr;
import soot.util.Switch;

public class JDynamicInvokeExpr
extends AbstractInvokeExpr
implements DynamicInvokeExpr,
ConvertToBaf {
    protected SootMethodRef bsmRef;
    protected ValueBox[] bsmArgBoxes;
    protected int tag;

    public JDynamicInvokeExpr(SootMethodRef bootstrapMethodRef, List<? extends Value> bootstrapArgs, SootMethodRef methodRef, int tag, List<? extends Value> methodArgs) {
        super(methodRef, new ValueBox[methodArgs.size()]);
        int i;
        if (!methodRef.getSignature().startsWith("<soot.dummy.InvokeDynamic: ")) {
            throw new IllegalArgumentException("Receiver type of JDynamicInvokeExpr must be soot.dummy.InvokeDynamic!");
        }
        this.bsmRef = bootstrapMethodRef;
        this.bsmArgBoxes = new ValueBox[bootstrapArgs.size()];
        this.tag = tag;
        for (i = 0; i < bootstrapArgs.size(); ++i) {
            this.bsmArgBoxes[i] = Jimple.v().newImmediateBox(bootstrapArgs.get(i));
        }
        for (i = 0; i < methodArgs.size(); ++i) {
            this.argBoxes[i] = Jimple.v().newImmediateBox(methodArgs.get(i));
        }
    }

    public JDynamicInvokeExpr(SootMethodRef bootstrapMethodRef, List<? extends Value> bootstrapArgs, SootMethodRef methodRef, List<? extends Value> methodArgs) {
        this(bootstrapMethodRef, bootstrapArgs, methodRef, MethodHandle.Kind.REF_INVOKE_STATIC.getValue(), methodArgs);
    }

    @Override
    public int getBootstrapArgCount() {
        return this.bsmArgBoxes.length;
    }

    @Override
    public Value getBootstrapArg(int index) {
        return this.bsmArgBoxes[index].getValue();
    }

    @Override
    public Object clone() {
        ArrayList<Value> clonedBsmArgs = new ArrayList<Value>(this.getBootstrapArgCount());
        for (int i = 0; i < this.getBootstrapArgCount(); ++i) {
            clonedBsmArgs.add(i, this.getBootstrapArg(i));
        }
        ArrayList<Value> clonedArgs = new ArrayList<Value>(this.getArgCount());
        for (int i = 0; i < this.getArgCount(); ++i) {
            clonedArgs.add(i, this.getArg(i));
        }
        return new JDynamicInvokeExpr(this.bsmRef, clonedBsmArgs, this.methodRef, this.tag, clonedArgs);
    }

    @Override
    public boolean equivTo(Object o) {
        if (o instanceof JDynamicInvokeExpr) {
            JDynamicInvokeExpr ie = (JDynamicInvokeExpr)o;
            if (!this.getMethod().equals(ie.getMethod()) || this.bsmArgBoxes.length != ie.bsmArgBoxes.length) {
                return false;
            }
            int i = 0;
            for (ValueBox element : this.bsmArgBoxes) {
                if (!element.getValue().equivTo(ie.getBootstrapArg(i))) {
                    return false;
                }
                ++i;
            }
            if (!this.getMethod().equals(ie.getMethod()) || (this.argBoxes == null ? 0 : this.argBoxes.length) != (ie.argBoxes == null ? 0 : ie.argBoxes.length)) {
                return false;
            }
            if (this.argBoxes != null) {
                i = 0;
                for (ValueBox element : this.argBoxes) {
                    if (!element.getValue().equivTo(ie.getArg(i))) {
                        return false;
                    }
                    ++i;
                }
            }
            if (!this.methodRef.equals(ie.methodRef)) {
                return false;
            }
            return this.bsmRef.equals(ie.bsmRef);
        }
        return false;
    }

    public SootMethod getBootstrapMethod() {
        return this.bsmRef.resolve();
    }

    @Override
    public int equivHashCode() {
        return this.getBootstrapMethod().equivHashCode() * this.getMethod().equivHashCode() * 17;
    }

    public String toString() {
        int i;
        StringBuffer buffer = new StringBuffer();
        buffer.append("dynamicinvoke");
        buffer.append(" \"");
        buffer.append(this.methodRef.name());
        buffer.append("\" <");
        buffer.append(SootMethod.getSubSignature("", this.methodRef.parameterTypes(), this.methodRef.returnType()));
        buffer.append(">(");
        if (this.argBoxes != null) {
            for (i = 0; i < this.argBoxes.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.argBoxes[i].getValue().toString());
            }
        }
        buffer.append(") ");
        buffer.append(this.bsmRef.getSignature());
        buffer.append("(");
        for (i = 0; i < this.bsmArgBoxes.length; ++i) {
            if (i != 0) {
                buffer.append(", ");
            }
            buffer.append(this.bsmArgBoxes[i].getValue().toString());
        }
        buffer.append(")");
        return buffer.toString();
    }

    @Override
    public void toString(UnitPrinter up) {
        int i;
        up.literal("dynamicinvoke");
        up.literal(" \"" + this.methodRef.name() + "\" <" + SootMethod.getSubSignature("", this.methodRef.parameterTypes(), this.methodRef.returnType()) + ">(");
        if (this.argBoxes != null) {
            for (i = 0; i < this.argBoxes.length; ++i) {
                if (i != 0) {
                    up.literal(", ");
                }
                this.argBoxes[i].toString(up);
            }
        }
        up.literal(") ");
        up.methodRef(this.bsmRef);
        up.literal("(");
        for (i = 0; i < this.bsmArgBoxes.length; ++i) {
            if (i != 0) {
                up.literal(", ");
            }
            this.bsmArgBoxes[i].toString(up);
        }
        up.literal(")");
    }

    @Override
    public void apply(Switch sw) {
        ((ExprSwitch)sw).caseDynamicInvokeExpr(this);
    }

    @Override
    public void convertToBaf(JimpleToBafContext context, List<Unit> out) {
        if (this.argBoxes != null) {
            for (ValueBox element : this.argBoxes) {
                ((ConvertToBaf)((Object)element.getValue())).convertToBaf(context, out);
            }
        }
        ArrayList<Value> bsmArgs = new ArrayList<Value>();
        for (ValueBox argBox : this.bsmArgBoxes) {
            bsmArgs.add(argBox.getValue());
        }
        DynamicInvokeInst u = Baf.v().newDynamicInvokeInst(this.bsmRef, bsmArgs, this.methodRef, this.tag);
        u.addAllTagsOf(context.getCurrentUnit());
        out.add(u);
    }

    @Override
    public SootMethodRef getBootstrapMethodRef() {
        return this.bsmRef;
    }

    @Override
    public List<Value> getBootstrapArgs() {
        ArrayList<Value> l = new ArrayList<Value>();
        for (ValueBox element : this.bsmArgBoxes) {
            l.add(element.getValue());
        }
        return l;
    }

    @Override
    public int getHandleTag() {
        return this.tag;
    }
}

