/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.spark.ondemand.pautil;

import java.util.Set;
import soot.jimple.spark.ondemand.genericutil.HashSetMultiMap;
import soot.jimple.spark.ondemand.genericutil.MultiMap;
import soot.jimple.spark.ondemand.pautil.SootUtil;
import soot.jimple.spark.pag.FieldRefNode;
import soot.jimple.spark.pag.Node;
import soot.jimple.spark.pag.PAG;
import soot.jimple.spark.pag.SparkField;
import soot.jimple.spark.pag.VarNode;
import soot.toolkits.scalar.Pair;

public class ValidMatches {
    private final MultiMap<VarNode, VarNode> vMatchEdges = new HashSetMultiMap<VarNode, VarNode>();
    private final MultiMap<VarNode, VarNode> vMatchBarEdges = new HashSetMultiMap<VarNode, VarNode>();

    public ValidMatches(PAG pag, SootUtil.FieldToEdgesMap fieldToStores) {
        for (FieldRefNode loadSource : pag.loadSources()) {
            SparkField field = loadSource.getField();
            VarNode loadBase = loadSource.getBase();
            Set storesOnField = fieldToStores.get(field);
            for (Pair store : storesOnField) {
                VarNode storeBase = (VarNode)store.getO2();
                if (!loadBase.getP2Set().hasNonEmptyIntersection(storeBase.getP2Set())) continue;
                VarNode matchSrc = (VarNode)store.getO1();
                Node[] loadTargets = pag.loadLookup(loadSource);
                for (int i = 0; i < loadTargets.length; ++i) {
                    VarNode matchTgt = (VarNode)loadTargets[i];
                    this.vMatchEdges.put(matchSrc, matchTgt);
                    this.vMatchBarEdges.put(matchTgt, matchSrc);
                }
            }
        }
    }

    public Set<VarNode> vMatchLookup(VarNode src) {
        return this.vMatchEdges.get(src);
    }

    public Set<VarNode> vMatchInvLookup(VarNode src) {
        return this.vMatchBarEdges.get(src);
    }
}

