/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.annotation.fields;

import java.util.ArrayList;
import java.util.Map;
import soot.Body;
import soot.G;
import soot.Scene;
import soot.SceneTransformer;
import soot.Singletons;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Value;
import soot.ValueBox;
import soot.jimple.FieldRef;
import soot.tagkit.ColorTag;
import soot.tagkit.StringTag;

public class UnreachableFieldsTagger
extends SceneTransformer {
    public UnreachableFieldsTagger(Singletons.Global g) {
    }

    public static UnreachableFieldsTagger v() {
        return G.v().soot_jimple_toolkits_annotation_fields_UnreachableFieldsTagger();
    }

    protected void internalTransform(String phaseName, Map options) {
        ArrayList<SootField> fieldList = new ArrayList<SootField>();
        for (SootClass appClass : Scene.v().getApplicationClasses()) {
            for (SootField field : appClass.getFields()) {
                fieldList.add(field);
            }
        }
        for (SootClass appClass : Scene.v().getApplicationClasses()) {
            for (SootMethod sm : appClass.getMethods()) {
                if (!sm.hasActiveBody() || !Scene.v().getReachableMethods().contains(sm)) continue;
                Body b = sm.getActiveBody();
                for (ValueBox vBox : b.getUseBoxes()) {
                    FieldRef fieldRef;
                    SootField f;
                    Value v = vBox.getValue();
                    if (!(v instanceof FieldRef) || !fieldList.contains(f = (fieldRef = (FieldRef)v).getField())) continue;
                    int index = fieldList.indexOf(f);
                    fieldList.remove(index);
                }
            }
        }
        for (SootField unusedField : fieldList) {
            unusedField.addTag(new StringTag("Field " + unusedField.getName() + " is not used!", "Unreachable Fields"));
            unusedField.addTag(new ColorTag(0, true, "Unreachable Fields"));
        }
    }
}

