/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.callgraph;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.AnySubType;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.Context;
import soot.DoubleType;
import soot.EntryPoints;
import soot.FastHierarchy;
import soot.FloatType;
import soot.IntType;
import soot.Kind;
import soot.Local;
import soot.LongType;
import soot.MethodContext;
import soot.MethodOrMethodContext;
import soot.NullType;
import soot.PackManager;
import soot.PhaseOptions;
import soot.PrimType;
import soot.RefLikeType;
import soot.RefType;
import soot.Scene;
import soot.SceneTransformer;
import soot.ShortType;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Transform;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.javaToJimple.LocalGenerator;
import soot.jimple.AssignStmt;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.FieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.InvokeStmt;
import soot.jimple.Jimple;
import soot.jimple.NewArrayExpr;
import soot.jimple.NewExpr;
import soot.jimple.NewMultiArrayExpr;
import soot.jimple.NullConstant;
import soot.jimple.SpecialInvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.spark.pag.AllocDotField;
import soot.jimple.toolkits.annotation.nullcheck.NullnessAnalysis;
import soot.jimple.toolkits.callgraph.CallGraph;
import soot.jimple.toolkits.callgraph.ConstantArrayAnalysis;
import soot.jimple.toolkits.callgraph.ContextManager;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.callgraph.InvokeCallSite;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.jimple.toolkits.callgraph.ReflectionModel;
import soot.jimple.toolkits.callgraph.VirtualCallSite;
import soot.jimple.toolkits.callgraph.VirtualCalls;
import soot.jimple.toolkits.reflection.ReflectionTraceInfo;
import soot.options.CGOptions;
import soot.options.Options;
import soot.options.SparkOptions;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.util.HashMultiMap;
import soot.util.LargeNumberedMap;
import soot.util.MultiMap;
import soot.util.NumberedString;
import soot.util.SmallNumberedMap;
import soot.util.queue.ChunkedQueue;
import soot.util.queue.QueueReader;

public final class OnFlyCallGraphBuilder {
    private static final Logger logger = LoggerFactory.getLogger(OnFlyCallGraphBuilder.class);
    private static final PrimType[] CHAR_NARROWINGS = new PrimType[]{CharType.v()};
    private static final PrimType[] INT_NARROWINGS = new PrimType[]{IntType.v(), CharType.v(), ShortType.v(), ByteType.v(), ShortType.v()};
    private static final PrimType[] SHORT_NARROWINGS = new PrimType[]{ShortType.v(), ByteType.v()};
    private static final PrimType[] LONG_NARROWINGS = new PrimType[]{LongType.v(), IntType.v(), CharType.v(), ShortType.v(), ByteType.v(), ShortType.v()};
    private static final ByteType[] BYTE_NARROWINGS = new ByteType[]{ByteType.v()};
    private static final PrimType[] FLOAT_NARROWINGS = new PrimType[]{FloatType.v(), LongType.v(), IntType.v(), CharType.v(), ShortType.v(), ByteType.v(), ShortType.v()};
    private static final PrimType[] BOOLEAN_NARROWINGS = new PrimType[]{BooleanType.v()};
    private static final PrimType[] DOUBLE_NARROWINGS = new PrimType[]{DoubleType.v(), FloatType.v(), LongType.v(), IntType.v(), CharType.v(), ShortType.v(), ByteType.v(), ShortType.v()};
    protected final NumberedString sigFinalize = Scene.v().getSubSigNumberer().findOrAdd("void finalize()");
    protected final NumberedString sigInit = Scene.v().getSubSigNumberer().findOrAdd("void <init>()");
    protected final NumberedString sigStart = Scene.v().getSubSigNumberer().findOrAdd("void start()");
    protected final NumberedString sigRun = Scene.v().getSubSigNumberer().findOrAdd("void run()");
    protected final NumberedString sigExecute = Scene.v().getSubSigNumberer().findOrAdd("android.os.AsyncTask execute(java.lang.Object[])");
    protected final NumberedString sigExecutorExecute = Scene.v().getSubSigNumberer().findOrAdd("void execute(java.lang.Runnable)");
    protected final NumberedString sigHandlerPost = Scene.v().getSubSigNumberer().findOrAdd("boolean post(java.lang.Runnable)");
    protected final NumberedString sigHandlerPostAtFrontOfQueue = Scene.v().getSubSigNumberer().findOrAdd("boolean postAtFrontOfQueue(java.lang.Runnable)");
    protected final NumberedString sigHandlerPostAtTime = Scene.v().getSubSigNumberer().findOrAdd("boolean postAtTime(java.lang.Runnable,long)");
    protected final NumberedString sigHandlerPostAtTimeWithToken = Scene.v().getSubSigNumberer().findOrAdd("boolean postAtTime(java.lang.Runnable,java.lang.Object,long)");
    protected final NumberedString sigHandlerPostDelayed = Scene.v().getSubSigNumberer().findOrAdd("boolean postDelayed(java.lang.Runnable,long)");
    protected final NumberedString sigHandlerSendEmptyMessage = Scene.v().getSubSigNumberer().findOrAdd("boolean sendEmptyMessage(int)");
    protected final NumberedString sigHandlerSendEmptyMessageAtTime = Scene.v().getSubSigNumberer().findOrAdd("boolean sendEmptyMessageAtTime(int,long)");
    protected final NumberedString sigHandlerSendEmptyMessageDelayed = Scene.v().getSubSigNumberer().findOrAdd("boolean sendEmptyMessageDelayed(int,long)");
    protected final NumberedString sigHandlerSendMessage = Scene.v().getSubSigNumberer().findOrAdd("boolean postAtTime(java.lang.Runnable,long)");
    protected final NumberedString sigHandlerSendMessageAtFrontOfQueue = Scene.v().getSubSigNumberer().findOrAdd("boolean sendMessageAtFrontOfQueue(android.os.Message)");
    protected final NumberedString sigHandlerSendMessageAtTime = Scene.v().getSubSigNumberer().findOrAdd("boolean sendMessageAtTime(android.os.Message,long)");
    protected final NumberedString sigHandlerSendMessageDelayed = Scene.v().getSubSigNumberer().findOrAdd("boolean sendMessageDelayed(android.os.Message,long)");
    protected final NumberedString sigHandlerHandleMessage = Scene.v().getSubSigNumberer().findOrAdd("void handleMessage(android.os.Message)");
    protected final NumberedString sigObjRun = Scene.v().getSubSigNumberer().findOrAdd("java.lang.Object run()");
    protected final NumberedString sigDoInBackground = Scene.v().getSubSigNumberer().findOrAdd("java.lang.Object doInBackground(java.lang.Object[])");
    protected final NumberedString sigForName = Scene.v().getSubSigNumberer().findOrAdd("java.lang.Class forName(java.lang.String)");
    protected final RefType clRunnable = RefType.v("java.lang.Runnable");
    protected final RefType clAsyncTask = RefType.v("android.os.AsyncTask");
    protected final RefType clHandler = RefType.v("android.os.Handler");
    private final CallGraph cicg = Scene.v().internalMakeCallGraph();
    private final HashSet<SootMethod> analyzedMethods = new HashSet();
    private final LargeNumberedMap<Local, List<VirtualCallSite>> receiverToSites = new LargeNumberedMap(Scene.v().getLocalNumberer());
    private final LargeNumberedMap<SootMethod, List<Local>> methodToReceivers = new LargeNumberedMap(Scene.v().getMethodNumberer());
    private final LargeNumberedMap<SootMethod, List<Local>> methodToInvokeBases = new LargeNumberedMap(Scene.v().getMethodNumberer());
    private final LargeNumberedMap<SootMethod, List<Local>> methodToInvokeArgs = new LargeNumberedMap(Scene.v().getMethodNumberer());
    private final MultiMap<Local, InvokeCallSite> baseToInvokeSite = new HashMultiMap<Local, InvokeCallSite>();
    private final MultiMap<Local, InvokeCallSite> invokeArgsToInvokeSite = new HashMultiMap<Local, InvokeCallSite>();
    private final Map<Local, BitSet> invokeArgsToSize = new IdentityHashMap<Local, BitSet>();
    private final MultiMap<AllocDotField, Local> allocDotFieldToLocal = new HashMultiMap<AllocDotField, Local>();
    private final MultiMap<Local, Type> reachingArgTypes = new HashMultiMap<Local, Type>();
    private final MultiMap<Local, Type> reachingBaseTypes = new HashMultiMap<Local, Type>();
    private final SmallNumberedMap<List<VirtualCallSite>> stringConstToSites = new SmallNumberedMap();
    private final LargeNumberedMap<SootMethod, List<Local>> methodToStringConstants = new LargeNumberedMap(Scene.v().getMethodNumberer());
    private final ChunkedQueue<SootMethod> targetsQueue = new ChunkedQueue();
    private final QueueReader<SootMethod> targets = this.targetsQueue.reader();
    ReflectionModel reflectionModel;
    private CGOptions options;
    private boolean appOnly;
    private ReachableMethods rm;
    private QueueReader<MethodOrMethodContext> worklist;
    private ContextManager cm;
    private FastHierarchy fh;
    private NullnessAnalysis nullnessCache = null;
    private ConstantArrayAnalysis arrayCache = null;
    private SootMethod analysisKey = null;

    public OnFlyCallGraphBuilder(ContextManager cm, ReachableMethods rm) {
        this.cm = cm;
        this.rm = rm;
        this.worklist = rm.listener();
        this.options = new CGOptions(PhaseOptions.v().getPhaseOptions("cg"));
        if (!this.options.verbose()) {
            logger.debug("[Call Graph] For information on where the call graph may be incomplete,use the verbose option to the cg phase.");
        }
        this.reflectionModel = this.options.reflection_log() == null || this.options.reflection_log().length() == 0 ? (this.options.types_for_invoke() && new SparkOptions(PhaseOptions.v().getPhaseOptions("cg.spark")).enabled() ? new TypeBasedReflectionModel() : new DefaultReflectionModel()) : new TraceBasedReflectionModel();
        this.fh = Scene.v().getOrMakeFastHierarchy();
    }

    public OnFlyCallGraphBuilder(ContextManager cm, ReachableMethods rm, boolean appOnly) {
        this(cm, rm);
        this.appOnly = appOnly;
    }

    public LargeNumberedMap<SootMethod, List<Local>> methodToReceivers() {
        return this.methodToReceivers;
    }

    public LargeNumberedMap<SootMethod, List<Local>> methodToInvokeArgs() {
        return this.methodToInvokeArgs;
    }

    public LargeNumberedMap<SootMethod, List<Local>> methodToInvokeBases() {
        return this.methodToInvokeBases;
    }

    public LargeNumberedMap<SootMethod, List<Local>> methodToStringConstants() {
        return this.methodToStringConstants;
    }

    public void processReachables() {
        while (true) {
            if (!this.worklist.hasNext()) {
                this.rm.update();
                if (!this.worklist.hasNext()) break;
            }
            MethodOrMethodContext momc = this.worklist.next();
            SootMethod m = momc.method();
            if (this.appOnly && !m.getDeclaringClass().isApplicationClass()) continue;
            if (this.analyzedMethods.add(m)) {
                this.processNewMethod(m);
            }
            this.processNewMethodContext(momc);
        }
    }

    public boolean wantTypes(Local receiver) {
        return this.receiverToSites.get(receiver) != null || this.baseToInvokeSite.get(receiver) != null;
    }

    public void addBaseType(Local base, Context context, Type ty) {
        assert (context == null);
        Set<InvokeCallSite> invokeSites = this.baseToInvokeSite.get(base);
        if (invokeSites != null && this.reachingBaseTypes.put(base, ty)) {
            this.resolveInvoke(invokeSites);
        }
    }

    public void addInvokeArgType(Local argArray, Context context, Type t) {
        assert (context == null);
        Set<InvokeCallSite> invokeSites = this.invokeArgsToInvokeSite.get(argArray);
        if (invokeSites != null && this.reachingArgTypes.put(argArray, t)) {
            this.resolveInvoke(invokeSites);
        }
    }

    public void setArgArrayNonDetSize(Local argArray, Context context) {
        assert (context == null);
        Set<InvokeCallSite> invokeSites = this.invokeArgsToInvokeSite.get(argArray);
        if (invokeSites != null) {
            if (this.invokeArgsToSize.containsKey(argArray)) {
                return;
            }
            this.invokeArgsToSize.put(argArray, null);
            this.resolveInvoke(invokeSites);
        }
    }

    public void addPossibleArgArraySize(Local argArray, int value, Context context) {
        assert (context == null);
        Set<InvokeCallSite> invokeSites = this.invokeArgsToInvokeSite.get(argArray);
        if (invokeSites != null) {
            BitSet sizeSet = this.invokeArgsToSize.get(argArray);
            if (sizeSet != null && sizeSet.isEmpty()) {
                return;
            }
            if (sizeSet == null) {
                sizeSet = new BitSet();
                this.invokeArgsToSize.put(argArray, sizeSet);
            }
            if (!sizeSet.get(value)) {
                sizeSet.set(value);
                this.resolveInvoke(invokeSites);
            }
        }
    }

    private Set<Type> resolveToClasses(Set<Type> rawTypes) {
        HashSet<Type> toReturn = new HashSet<Type>();
        for (Type ty : rawTypes) {
            if (ty instanceof AnySubType) {
                AnySubType anySubType = (AnySubType)ty;
                RefType base = anySubType.getBase();
                Set<SootClass> classRoots = base.getSootClass().isInterface() ? this.fh.getAllImplementersOfInterface(base.getSootClass()) : Collections.singleton(base.getSootClass());
                toReturn.addAll(this.getTransitiveSubClasses(classRoots));
                continue;
            }
            if (!(ty instanceof ArrayType) && !(ty instanceof RefType)) continue;
            toReturn.add(ty);
        }
        return toReturn;
    }

    private Collection<Type> getTransitiveSubClasses(Set<SootClass> classRoots) {
        LinkedList<SootClass> worklist = new LinkedList<SootClass>(classRoots);
        HashSet<Type> resolved = new HashSet<Type>();
        while (!worklist.isEmpty()) {
            SootClass cls = worklist.removeFirst();
            if (!resolved.add(cls.getType())) continue;
            worklist.addAll(this.fh.getSubclassesOf(cls));
        }
        return resolved;
    }

    private void resolveInvoke(Collection<InvokeCallSite> list) {
        for (InvokeCallSite ics : list) {
            boolean mustBeNull;
            Set<Type> s = this.reachingBaseTypes.get(ics.base());
            if (s == null || s.isEmpty()) continue;
            if (ics.reachingTypes() != null) {
                assert (ics.nullnessCode() != 0);
                this.resolveStaticTypes(s, ics);
                continue;
            }
            boolean mustNotBeNull = ics.nullnessCode() == 1;
            boolean bl = mustBeNull = ics.nullnessCode() == 0;
            if (mustBeNull || ics.nullnessCode() == -1 && (!this.invokeArgsToSize.containsKey(ics.argArray()) || !this.reachingArgTypes.containsKey(ics.argArray()))) {
                for (Type bType : this.resolveToClasses(s)) {
                    assert (bType instanceof RefType);
                    SootClass baseClass = ((RefType)bType).getSootClass();
                    assert (!baseClass.isInterface());
                    Iterator<SootMethod> mIt = this.getPublicNullaryMethodIterator(baseClass);
                    while (mIt.hasNext()) {
                        SootMethod sm = mIt.next();
                        this.cm.addVirtualEdge(ics.container(), ics.stmt(), sm, Kind.REFL_INVOKE, null);
                    }
                }
                continue;
            }
            Set<Type> reachingTypes = this.reachingArgTypes.get(ics.argArray());
            if (reachingTypes == null || !this.invokeArgsToSize.containsKey(ics.argArray())) {
                assert (ics.nullnessCode() == 1) : ics;
                return;
            }
            assert (reachingTypes != null && this.invokeArgsToSize.containsKey(ics.argArray()));
            BitSet methodSizes = this.invokeArgsToSize.get(ics.argArray());
            for (Type bType : this.resolveToClasses(s)) {
                assert (bType instanceof RefLikeType);
                if (bType instanceof NullType || bType instanceof ArrayType) continue;
                SootClass baseClass = ((RefType)bType).getSootClass();
                Iterator<SootMethod> mIt = this.getPublicMethodIterator(baseClass, reachingTypes, methodSizes, mustNotBeNull);
                while (mIt.hasNext()) {
                    SootMethod sm = mIt.next();
                    this.cm.addVirtualEdge(ics.container(), ics.stmt(), sm, Kind.REFL_INVOKE, null);
                }
            }
        }
    }

    private void resolveStaticTypes(Set<Type> s, InvokeCallSite ics) {
        ConstantArrayAnalysis.ArrayTypes at = ics.reachingTypes();
        for (Type bType : this.resolveToClasses(s)) {
            SootClass baseClass = ((RefType)bType).getSootClass();
            Iterator<SootMethod> mIt = this.getPublicMethodIterator(baseClass, at);
            while (mIt.hasNext()) {
                SootMethod sm = mIt.next();
                this.cm.addVirtualEdge(ics.container(), ics.stmt(), sm, Kind.REFL_INVOKE, null);
            }
        }
    }

    private Iterator<SootMethod> getPublicMethodIterator(SootClass baseClass, final ConstantArrayAnalysis.ArrayTypes at) {
        return new AbstractMethodIterator(baseClass){

            @Override
            protected boolean acceptMethod(SootMethod m) {
                if (!at.possibleSizes.contains(m.getParameterCount())) {
                    return false;
                }
                for (int i = 0; i < m.getParameterCount(); ++i) {
                    if (at.possibleTypes[i].isEmpty() || OnFlyCallGraphBuilder.this.isReflectionCompatible(m.getParameterType(i), at.possibleTypes[i])) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private PrimType[] narrowings(PrimType f) {
        if (f instanceof IntType) {
            return INT_NARROWINGS;
        }
        if (f instanceof ShortType) {
            return SHORT_NARROWINGS;
        }
        if (f instanceof LongType) {
            return LONG_NARROWINGS;
        }
        if (f instanceof ByteType) {
            return BYTE_NARROWINGS;
        }
        if (f instanceof FloatType) {
            return FLOAT_NARROWINGS;
        }
        if (f instanceof BooleanType) {
            return BOOLEAN_NARROWINGS;
        }
        if (f instanceof DoubleType) {
            return DOUBLE_NARROWINGS;
        }
        if (f instanceof CharType) {
            return CHAR_NARROWINGS;
        }
        throw new RuntimeException("Unexpected primitive type: " + f);
    }

    private boolean isReflectionCompatible(Type paramType, Set<Type> reachingTypes) {
        if (reachingTypes.contains(NullType.v())) {
            return true;
        }
        if (paramType instanceof RefLikeType) {
            for (Type rType : reachingTypes) {
                if (!this.fh.canStoreType(paramType, rType)) continue;
                return true;
            }
            return false;
        }
        if (paramType instanceof PrimType) {
            PrimType primType = (PrimType)paramType;
            for (PrimType narrowings : this.narrowings(primType)) {
                if (!reachingTypes.contains(narrowings.boxedType())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private Iterator<SootMethod> getPublicMethodIterator(SootClass baseClass, final Set<Type> reachingTypes, final BitSet methodSizes, final boolean mustNotBeNull) {
        if (baseClass.isPhantom()) {
            return Collections.emptyIterator();
        }
        return new AbstractMethodIterator(baseClass){

            @Override
            protected boolean acceptMethod(SootMethod n) {
                int nParams = n.getParameterCount();
                if (methodSizes != null) {
                    boolean compatibleSize;
                    boolean bl = compatibleSize = methodSizes.get(nParams) || !mustNotBeNull && nParams == 0;
                    if (!compatibleSize) {
                        return false;
                    }
                }
                List<Type> t = n.getParameterTypes();
                for (Type pTy : t) {
                    if (OnFlyCallGraphBuilder.this.isReflectionCompatible(pTy, reachingTypes)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    private Iterator<SootMethod> getPublicNullaryMethodIterator(SootClass baseClass) {
        if (baseClass.isPhantom()) {
            return Collections.emptyIterator();
        }
        return new AbstractMethodIterator(baseClass){

            @Override
            protected boolean acceptMethod(SootMethod n) {
                int nParams = n.getParameterCount();
                return nParams == 0;
            }
        };
    }

    public void addType(Local receiver, Context srcContext, Type type, Context typeContext) {
        FastHierarchy fh = Scene.v().getOrMakeFastHierarchy();
        if (this.receiverToSites.get(receiver) != null) {
            for (VirtualCallSite site : this.receiverToSites.get(receiver)) {
                SootMethod target;
                if (site.kind() == Kind.THREAD && !fh.canStoreType(type, this.clRunnable) || site.kind() == Kind.EXECUTOR && !fh.canStoreType(type, this.clRunnable) || site.kind() == Kind.ASYNCTASK && !fh.canStoreType(type, this.clAsyncTask) || site.kind() == Kind.HANDLER && !fh.canStoreType(type, this.clHandler)) continue;
                if (site.iie() instanceof SpecialInvokeExpr && site.kind != Kind.THREAD && site.kind != Kind.EXECUTOR && site.kind != Kind.ASYNCTASK) {
                    target = VirtualCalls.v().resolveSpecial((SpecialInvokeExpr)site.iie(), site.subSig(), site.container(), this.appOnly);
                    if (target != null) {
                        this.targetsQueue.add(target);
                    }
                } else {
                    VirtualCalls.v().resolve(type, receiver.getType(), site.subSig(), site.container(), this.targetsQueue, this.appOnly);
                    if (!this.targets.hasNext() && this.options.resolve_all_abstract_invokes()) {
                        VirtualCalls.v().resolveSuperType(type, receiver.getType(), site.subSig(), this.targetsQueue, this.appOnly);
                    }
                }
                while (this.targets.hasNext()) {
                    target = this.targets.next();
                    this.cm.addVirtualEdge(MethodContext.v(site.container(), srcContext), site.stmt(), target, site.kind(), typeContext);
                }
            }
        }
        if (this.baseToInvokeSite.get(receiver) != null) {
            this.addBaseType(receiver, srcContext, type);
        }
    }

    public boolean wantStringConstants(Local stringConst) {
        return this.stringConstToSites.get(stringConst) != null;
    }

    public void addStringConstant(Local l, Context srcContext, String constant) {
        for (VirtualCallSite site : this.stringConstToSites.get(l)) {
            if (constant == null) {
                if (!this.options.verbose()) continue;
                logger.debug("Warning: Method " + site.container() + " is reachable, and calls Class.forName on a non-constant String; graph will be incomplete! Use safe-forname option for a conservative result.");
                continue;
            }
            if (constant.length() > 0 && constant.charAt(0) == '[') {
                if (constant.length() <= 1 || constant.charAt(1) != 'L' || constant.charAt(constant.length() - 1) != ';') continue;
                constant = constant.substring(2, constant.length() - 1);
            }
            if (!Scene.v().containsClass(constant)) {
                if (!this.options.verbose()) continue;
                logger.debug("Warning: Class " + constant + " is a dynamic class, and you did not specify it as such; graph will be incomplete!");
                continue;
            }
            SootClass sootcls = Scene.v().getSootClass(constant);
            if (!sootcls.isApplicationClass() && !sootcls.isPhantom()) {
                sootcls.setLibraryClass();
            }
            for (SootMethod clinit : EntryPoints.v().clinitsOf(sootcls)) {
                this.cm.addStaticEdge(MethodContext.v(site.container(), srcContext), site.stmt(), clinit, Kind.CLINIT);
            }
        }
    }

    public boolean wantArrayField(AllocDotField df) {
        return this.allocDotFieldToLocal.containsKey(df);
    }

    public void addInvokeArgType(AllocDotField df, Context context, Type type) {
        if (!this.allocDotFieldToLocal.containsKey(df)) {
            return;
        }
        for (Local l : this.allocDotFieldToLocal.get(df)) {
            this.addInvokeArgType(l, context, type);
        }
    }

    public boolean wantInvokeArg(Local receiver) {
        return this.invokeArgsToInvokeSite.containsKey(receiver);
    }

    public void addInvokeArgDotField(Local receiver, AllocDotField dot) {
        this.allocDotFieldToLocal.put(dot, receiver);
    }

    private void addInvokeCallSite(Stmt s, SootMethod container2, InstanceInvokeExpr d) {
        InvokeCallSite ics;
        Local l = (Local)d.getArg(0);
        Value argArray = d.getArg(1);
        if (argArray instanceof NullConstant) {
            ics = new InvokeCallSite(s, container2, d, l);
        } else {
            Local argLocal;
            int nullnessCode;
            if (this.analysisKey != container2) {
                ExceptionalUnitGraph graph = new ExceptionalUnitGraph(container2.getActiveBody());
                this.nullnessCache = new NullnessAnalysis(graph);
                this.arrayCache = new ConstantArrayAnalysis(graph, container2.getActiveBody());
                this.analysisKey = container2;
            }
            if ((nullnessCode = this.nullnessCache.isAlwaysNonNullBefore(s, argLocal = (Local)argArray) ? 1 : (this.nullnessCache.isAlwaysNullBefore(s, argLocal) ? 0 : -1)) != 0 && this.arrayCache.isConstantBefore(s, argLocal)) {
                ConstantArrayAnalysis.ArrayTypes reachingArgTypes = this.arrayCache.getArrayTypesBefore(s, argLocal);
                if (nullnessCode == -1) {
                    reachingArgTypes.possibleSizes.add(0);
                }
                ics = new InvokeCallSite(s, container2, d, l, reachingArgTypes, nullnessCode);
            } else {
                ics = new InvokeCallSite(s, container2, d, l, argLocal, nullnessCode);
                this.invokeArgsToInvokeSite.put(argLocal, ics);
            }
        }
        this.baseToInvokeSite.put(l, ics);
    }

    private void addVirtualCallSite(Stmt s, SootMethod m, Local receiver, InstanceInvokeExpr iie, NumberedString subSig, Kind kind) {
        List<VirtualCallSite> sites = this.receiverToSites.get(receiver);
        if (sites == null) {
            sites = new ArrayList<VirtualCallSite>();
            this.receiverToSites.put(receiver, sites);
            List<Local> receivers = this.methodToReceivers.get(m);
            if (receivers == null) {
                receivers = new ArrayList<Local>();
                this.methodToReceivers.put(m, receivers);
            }
            receivers.add(receiver);
        }
        sites.add(new VirtualCallSite(s, m, iie, subSig, kind));
    }

    private void processNewMethod(SootMethod m) {
        if (!m.isConcrete()) {
            return;
        }
        Body b = m.retrieveActiveBody();
        this.getImplicitTargets(m);
        this.findReceivers(m, b);
    }

    private void findReceivers(SootMethod m, Body b) {
        for (Unit u : b.getUnits()) {
            Stmt s = (Stmt)u;
            if (!s.containsInvokeExpr()) continue;
            InvokeExpr ie = s.getInvokeExpr();
            if (ie instanceof InstanceInvokeExpr) {
                InstanceInvokeExpr iie = (InstanceInvokeExpr)ie;
                Local receiver = (Local)iie.getBase();
                NumberedString subSig = iie.getMethodRef().getSubSignature();
                this.addVirtualCallSite(s, m, receiver, iie, subSig, Edge.ieToKind(iie));
                if (subSig == this.sigStart) {
                    this.addVirtualCallSite(s, m, receiver, iie, this.sigRun, Kind.THREAD);
                    continue;
                }
                if (subSig == this.sigExecutorExecute || subSig == this.sigHandlerPost || subSig == this.sigHandlerPostAtFrontOfQueue || subSig == this.sigHandlerPostAtTime || subSig == this.sigHandlerPostAtTimeWithToken || subSig == this.sigHandlerPostDelayed) {
                    Value runnable;
                    if (iie.getArgCount() <= 0 || !((runnable = iie.getArg(0)) instanceof Local)) continue;
                    this.addVirtualCallSite(s, m, (Local)runnable, iie, this.sigRun, Kind.EXECUTOR);
                    continue;
                }
                if (subSig == this.sigHandlerSendEmptyMessage || subSig == this.sigHandlerSendEmptyMessageAtTime || subSig == this.sigHandlerSendEmptyMessageDelayed || subSig == this.sigHandlerSendMessage || subSig == this.sigHandlerSendMessageAtFrontOfQueue || subSig == this.sigHandlerSendMessageAtTime || subSig == this.sigHandlerSendMessageDelayed) {
                    this.addVirtualCallSite(s, m, receiver, iie, this.sigHandlerHandleMessage, Kind.HANDLER);
                    continue;
                }
                if (subSig != this.sigExecute) continue;
                this.addVirtualCallSite(s, m, receiver, iie, this.sigDoInBackground, Kind.ASYNCTASK);
                continue;
            }
            if (ie instanceof DynamicInvokeExpr) {
                if (!this.options.verbose()) continue;
                logger.debug("WARNING: InvokeDynamic to " + ie + " not resolved during call-graph construction.");
                continue;
            }
            SootMethod tgt = ie.getMethod();
            if (tgt != null) {
                this.addEdge(m, s, tgt);
                String signature = tgt.getSignature();
                if (!signature.equals("<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedAction)>") && !signature.equals("<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedExceptionAction)>") && !signature.equals("<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedAction,java.security.AccessControlContext)>") && !signature.equals("<java.security.AccessController: java.lang.Object doPrivileged(java.security.PrivilegedExceptionAction,java.security.AccessControlContext)>")) continue;
                Local receiver = (Local)ie.getArg(0);
                this.addVirtualCallSite(s, m, receiver, null, this.sigObjRun, Kind.PRIVILEGED);
                continue;
            }
            if (Options.v().ignore_resolution_errors()) continue;
            throw new InternalError("Unresolved target " + ie.getMethod() + ". Resolution error should have occured earlier.");
        }
    }

    private void getImplicitTargets(SootMethod source) {
        SootClass scl = source.getDeclaringClass();
        if (!source.isConcrete()) {
            return;
        }
        if (source.getSubSignature().indexOf("<init>") >= 0) {
            this.handleInit(source, scl);
        }
        Body b = source.retrieveActiveBody();
        for (Unit u : b.getUnits()) {
            FieldRef fr;
            Object cl;
            Stmt s = (Stmt)u;
            if (s.containsInvokeExpr()) {
                InvokeExpr ie = s.getInvokeExpr();
                SootMethodRef methodRef = ie.getMethodRef();
                switch (methodRef.declaringClass().getName()) {
                    case "java.lang.reflect.Method": {
                        if (!methodRef.getSubSignature().getString().equals("java.lang.Object invoke(java.lang.Object,java.lang.Object[])")) break;
                        this.reflectionModel.methodInvoke(source, s);
                        break;
                    }
                    case "java.lang.Class": {
                        if (!methodRef.getSubSignature().getString().equals("java.lang.Object newInstance()")) break;
                        this.reflectionModel.classNewInstance(source, s);
                        break;
                    }
                    case "java.lang.reflect.Constructor": {
                        if (!methodRef.getSubSignature().getString().equals("java.lang.Object newInstance(java.lang.Object[])")) break;
                        this.reflectionModel.contructorNewInstance(source, s);
                    }
                }
                if (methodRef.getSubSignature() == this.sigForName) {
                    this.reflectionModel.classForName(source, s);
                }
                if (ie instanceof StaticInvokeExpr) {
                    cl = ie.getMethodRef().declaringClass();
                    for (SootMethod clinit : EntryPoints.v().clinitsOf((SootClass)cl)) {
                        this.addEdge(source, s, clinit, Kind.CLINIT);
                    }
                }
            }
            if (s.containsFieldRef() && (fr = s.getFieldRef()) instanceof StaticFieldRef) {
                SootClass cl2 = fr.getFieldRef().declaringClass();
                for (SootMethod clinit : EntryPoints.v().clinitsOf(cl2)) {
                    this.addEdge(source, s, clinit, Kind.CLINIT);
                }
            }
            if (!(s instanceof AssignStmt)) continue;
            Value rhs = ((AssignStmt)s).getRightOp();
            if (rhs instanceof NewExpr) {
                NewExpr r = (NewExpr)rhs;
                cl = r.getBaseType().getSootClass();
                for (SootMethod clinit : EntryPoints.v().clinitsOf((SootClass)cl)) {
                    this.addEdge(source, s, clinit, Kind.CLINIT);
                }
                continue;
            }
            if (!(rhs instanceof NewArrayExpr) && !(rhs instanceof NewMultiArrayExpr)) continue;
            Type t = rhs.getType();
            if (t instanceof ArrayType) {
                t = ((ArrayType)t).baseType;
            }
            if (!(t instanceof RefType)) continue;
            cl = ((RefType)t).getSootClass();
            for (SootMethod clinit : EntryPoints.v().clinitsOf((SootClass)cl)) {
                this.addEdge(source, s, clinit, Kind.CLINIT);
            }
        }
    }

    private void processNewMethodContext(MethodOrMethodContext momc) {
        SootMethod m = momc.method();
        Iterator<Edge> it = this.cicg.edgesOutOf(m);
        while (it.hasNext()) {
            Edge e = it.next();
            this.cm.addStaticEdge(momc, e.srcUnit(), e.tgt(), e.kind());
        }
    }

    private void handleInit(SootMethod source, SootClass scl) {
        this.addEdge(source, null, scl, this.sigFinalize, Kind.FINALIZE);
    }

    private void constantForName(String cls, SootMethod src, Stmt srcUnit) {
        if (cls.length() > 0 && cls.charAt(0) == '[') {
            if (cls.length() > 1 && cls.charAt(1) == 'L' && cls.charAt(cls.length() - 1) == ';') {
                cls = cls.substring(2, cls.length() - 1);
                this.constantForName(cls, src, srcUnit);
            }
        } else if (!Scene.v().containsClass(cls)) {
            if (this.options.verbose()) {
                logger.warn("Class " + cls + " is a dynamic class, and you did not specify it as such; graph will be incomplete!");
            }
        } else {
            SootClass sootcls = Scene.v().getSootClass(cls);
            if (!sootcls.isPhantomClass()) {
                if (!sootcls.isApplicationClass()) {
                    sootcls.setLibraryClass();
                }
                for (SootMethod clinit : EntryPoints.v().clinitsOf(sootcls)) {
                    this.addEdge(src, srcUnit, clinit, Kind.CLINIT);
                }
            }
        }
    }

    private void addEdge(SootMethod src, Stmt stmt, SootMethod tgt, Kind kind) {
        this.cicg.addEdge(new Edge(src, stmt, tgt, kind));
    }

    private void addEdge(SootMethod src, Stmt stmt, SootClass cls, NumberedString methodSubSig, Kind kind) {
        SootMethod sm = cls.getMethodUnsafe(methodSubSig);
        if (sm != null) {
            this.addEdge(src, stmt, sm, kind);
        }
    }

    private void addEdge(SootMethod src, Stmt stmt, SootMethod tgt) {
        InvokeExpr ie = stmt.getInvokeExpr();
        this.addEdge(src, stmt, tgt, Edge.ieToKind(ie));
    }

    private abstract class AbstractMethodIterator
    implements Iterator<SootMethod> {
        private SootMethod next;
        private SootClass currClass;
        private Iterator<SootMethod> methodIterator;

        AbstractMethodIterator(SootClass baseClass) {
            this.currClass = baseClass;
            this.next = null;
            this.methodIterator = baseClass.methodIterator();
            this.findNextMethod();
        }

        protected void findNextMethod() {
            this.next = null;
            if (this.methodIterator == null) {
                return;
            }
            while (true) {
                if (this.methodIterator.hasNext()) {
                    SootMethod n = this.methodIterator.next();
                    if (!n.isPublic() || n.isStatic() || n.isConstructor() || n.isStaticInitializer() || !n.isConcrete() || !this.acceptMethod(n)) continue;
                    this.next = n;
                    return;
                }
                if (!this.currClass.hasSuperclass() || this.currClass.getSuperclass().isPhantom() || this.currClass.getSuperclass().getName().equals("java.lang.Object")) break;
                this.currClass = this.currClass.getSuperclass();
                this.methodIterator = this.currClass.methodIterator();
            }
            this.methodIterator = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public SootMethod next() {
            SootMethod toRet = this.next;
            this.findNextMethod();
            return toRet;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        protected abstract boolean acceptMethod(SootMethod var1);
    }

    public class TraceBasedReflectionModel
    implements ReflectionModel {
        protected Set<Guard> guards = new HashSet<Guard>();
        protected ReflectionTraceInfo reflectionInfo;
        private boolean registeredTransformation = false;

        private TraceBasedReflectionModel() {
            String logFile = OnFlyCallGraphBuilder.this.options.reflection_log();
            if (logFile == null) {
                throw new InternalError("Trace based refection model enabled but no trace file given!?");
            }
            this.reflectionInfo = new ReflectionTraceInfo(logFile);
        }

        @Override
        public void classForName(SootMethod container2, Stmt forNameInvokeStmt) {
            Set<String> classNames = this.reflectionInfo.classForNameClassNames(container2);
            if (classNames == null || classNames.isEmpty()) {
                this.registerGuard(container2, forNameInvokeStmt, "Class.forName() call site; Soot did not expect this site to be reached");
            } else {
                for (String clsName : classNames) {
                    OnFlyCallGraphBuilder.this.constantForName(clsName, container2, forNameInvokeStmt);
                }
            }
        }

        @Override
        public void classNewInstance(SootMethod container2, Stmt newInstanceInvokeStmt) {
            Set<String> classNames = this.reflectionInfo.classNewInstanceClassNames(container2);
            if (classNames == null || classNames.isEmpty()) {
                this.registerGuard(container2, newInstanceInvokeStmt, "Class.newInstance() call site; Soot did not expect this site to be reached");
            } else {
                for (String clsName : classNames) {
                    SootClass cls = Scene.v().getSootClass(clsName);
                    SootMethod constructor = cls.getMethodUnsafe(OnFlyCallGraphBuilder.this.sigInit);
                    if (constructor == null) continue;
                    OnFlyCallGraphBuilder.this.addEdge(container2, newInstanceInvokeStmt, constructor, Kind.REFL_CLASS_NEWINSTANCE);
                }
            }
        }

        @Override
        public void contructorNewInstance(SootMethod container2, Stmt newInstanceInvokeStmt) {
            Set<String> constructorSignatures = this.reflectionInfo.constructorNewInstanceSignatures(container2);
            if (constructorSignatures == null || constructorSignatures.isEmpty()) {
                this.registerGuard(container2, newInstanceInvokeStmt, "Constructor.newInstance(..) call site; Soot did not expect this site to be reached");
            } else {
                for (String constructorSignature : constructorSignatures) {
                    SootMethod constructor = Scene.v().getMethod(constructorSignature);
                    OnFlyCallGraphBuilder.this.addEdge(container2, newInstanceInvokeStmt, constructor, Kind.REFL_CONSTR_NEWINSTANCE);
                }
            }
        }

        @Override
        public void methodInvoke(SootMethod container2, Stmt invokeStmt) {
            Set<String> methodSignatures = this.reflectionInfo.methodInvokeSignatures(container2);
            if (methodSignatures == null || methodSignatures.isEmpty()) {
                this.registerGuard(container2, invokeStmt, "Method.invoke(..) call site; Soot did not expect this site to be reached");
            } else {
                for (String methodSignature : methodSignatures) {
                    SootMethod method = Scene.v().getMethod(methodSignature);
                    OnFlyCallGraphBuilder.this.addEdge(container2, invokeStmt, method, Kind.REFL_INVOKE);
                }
            }
        }

        private void registerGuard(SootMethod container2, Stmt stmt, String string) {
            this.guards.add(new Guard(container2, stmt, string));
            if (OnFlyCallGraphBuilder.this.options.verbose()) {
                logger.debug("Incomplete trace file: Class.forName() is called in method '" + container2 + "' but trace contains no information about the receiver class of this call.");
                if (OnFlyCallGraphBuilder.this.options.guards().equals("ignore")) {
                    logger.debug("Guarding strategy is set to 'ignore'. Will ignore this problem.");
                } else if (OnFlyCallGraphBuilder.this.options.guards().equals("print")) {
                    logger.debug("Guarding strategy is set to 'print'. Program will print a stack trace if this location is reached during execution.");
                } else if (OnFlyCallGraphBuilder.this.options.guards().equals("throw")) {
                    logger.debug("Guarding strategy is set to 'throw'. Program will throw an Error if this location is reached during execution.");
                } else {
                    throw new RuntimeException("Invalid value for phase option (guarding): " + OnFlyCallGraphBuilder.this.options.guards());
                }
            }
            if (!this.registeredTransformation) {
                this.registeredTransformation = true;
                PackManager.v().getPack("wjap").add(new Transform("wjap.guards", new SceneTransformer(){

                    @Override
                    protected void internalTransform(String phaseName, Map<String, String> options) {
                        for (Guard g : TraceBasedReflectionModel.this.guards) {
                            TraceBasedReflectionModel.this.insertGuard(g);
                        }
                    }
                }));
                PhaseOptions.v().setPhaseOption("wjap.guards", "enabled");
            }
        }

        private void insertGuard(Guard guard) {
            if (OnFlyCallGraphBuilder.this.options.guards().equals("ignore")) {
                return;
            }
            SootMethod container2 = guard.container;
            Stmt insertionPoint = guard.stmt;
            if (!container2.hasActiveBody()) {
                logger.warn("Tried to insert guard into " + container2 + " but couldn't because method has no body.");
            } else {
                Body body = container2.getActiveBody();
                RefType runtimeExceptionType = RefType.v("java.lang.Error");
                NewExpr newExpr = Jimple.v().newNewExpr(runtimeExceptionType);
                LocalGenerator lg = new LocalGenerator(body);
                Local exceptionLocal = lg.generateLocal(runtimeExceptionType);
                AssignStmt assignStmt = Jimple.v().newAssignStmt(exceptionLocal, newExpr);
                body.getUnits().insertBefore(assignStmt, insertionPoint);
                SootMethodRef cref = runtimeExceptionType.getSootClass().getMethod("<init>", Collections.singletonList(RefType.v("java.lang.String"))).makeRef();
                SpecialInvokeExpr constructorInvokeExpr = Jimple.v().newSpecialInvokeExpr(exceptionLocal, cref, (Value)StringConstant.v(guard.message));
                InvokeStmt initStmt = Jimple.v().newInvokeStmt(constructorInvokeExpr);
                body.getUnits().insertAfter(initStmt, assignStmt);
                if (OnFlyCallGraphBuilder.this.options.guards().equals("print")) {
                    VirtualInvokeExpr printStackTraceExpr = Jimple.v().newVirtualInvokeExpr(exceptionLocal, Scene.v().getSootClass("java.lang.Throwable").getMethod("printStackTrace", Collections.emptyList()).makeRef());
                    InvokeStmt printStackTraceStmt = Jimple.v().newInvokeStmt(printStackTraceExpr);
                    body.getUnits().insertAfter(printStackTraceStmt, initStmt);
                } else if (OnFlyCallGraphBuilder.this.options.guards().equals("throw")) {
                    body.getUnits().insertAfter(Jimple.v().newThrowStmt(exceptionLocal), initStmt);
                } else {
                    throw new RuntimeException("Invalid value for phase option (guarding): " + OnFlyCallGraphBuilder.this.options.guards());
                }
            }
        }

        class Guard {
            final SootMethod container;
            final Stmt stmt;
            final String message;

            public Guard(SootMethod container2, Stmt stmt, String message) {
                this.container = container2;
                this.stmt = stmt;
                this.message = message;
            }
        }
    }

    public class TypeBasedReflectionModel
    extends DefaultReflectionModel {
        @Override
        public void methodInvoke(SootMethod container2, Stmt invokeStmt) {
            if (container2.getDeclaringClass().isJavaLibraryClass()) {
                super.methodInvoke(container2, invokeStmt);
                return;
            }
            InstanceInvokeExpr d = (InstanceInvokeExpr)invokeStmt.getInvokeExpr();
            Value base = d.getArg(0);
            if (!(base instanceof Local)) {
                super.methodInvoke(container2, invokeStmt);
                return;
            }
            OnFlyCallGraphBuilder.this.addInvokeCallSite(invokeStmt, container2, d);
        }
    }

    public class DefaultReflectionModel
    implements ReflectionModel {
        protected CGOptions options = new CGOptions(PhaseOptions.v().getPhaseOptions("cg"));
        protected HashSet<SootMethod> warnedAlready = new HashSet();

        @Override
        public void classForName(SootMethod source, Stmt s) {
            InvokeExpr ie;
            Value className;
            ArrayList<Local> stringConstants = (ArrayList<Local>)OnFlyCallGraphBuilder.this.methodToStringConstants.get(source);
            if (stringConstants == null) {
                stringConstants = new ArrayList<Local>();
                OnFlyCallGraphBuilder.this.methodToStringConstants.put(source, stringConstants);
            }
            if ((className = (ie = s.getInvokeExpr()).getArg(0)) instanceof StringConstant) {
                String cls = ((StringConstant)className).value;
                OnFlyCallGraphBuilder.this.constantForName(cls, source, s);
            } else if (className instanceof Local) {
                Local constant = (Local)className;
                if (this.options.safe_forname()) {
                    for (SootMethod tgt : EntryPoints.v().clinits()) {
                        OnFlyCallGraphBuilder.this.addEdge(source, s, tgt, Kind.CLINIT);
                    }
                } else {
                    for (SootClass cls : Scene.v().dynamicClasses()) {
                        for (SootMethod clinit : EntryPoints.v().clinitsOf(cls)) {
                            OnFlyCallGraphBuilder.this.addEdge(source, s, clinit, Kind.CLINIT);
                        }
                    }
                    VirtualCallSite site = new VirtualCallSite(s, source, null, null, Kind.CLINIT);
                    ArrayList<VirtualCallSite> sites = (ArrayList<VirtualCallSite>)OnFlyCallGraphBuilder.this.stringConstToSites.get(constant);
                    if (sites == null) {
                        sites = new ArrayList<VirtualCallSite>();
                        OnFlyCallGraphBuilder.this.stringConstToSites.put(constant, sites);
                        stringConstants.add(constant);
                    }
                    sites.add(site);
                }
            }
        }

        @Override
        public void classNewInstance(SootMethod source, Stmt s) {
            if (this.options.safe_newinstance()) {
                for (SootMethod tgt : EntryPoints.v().inits()) {
                    OnFlyCallGraphBuilder.this.addEdge(source, s, tgt, Kind.NEWINSTANCE);
                }
            } else {
                for (SootClass cls : Scene.v().dynamicClasses()) {
                    SootMethod sm = cls.getMethodUnsafe(OnFlyCallGraphBuilder.this.sigInit);
                    if (sm == null) continue;
                    OnFlyCallGraphBuilder.this.addEdge(source, s, sm, Kind.NEWINSTANCE);
                }
                if (this.options.verbose()) {
                    logger.warn("Method " + source + " is reachable, and calls Class.newInstance; graph will be incomplete! Use safe-newinstance option for a conservative result.");
                }
            }
        }

        @Override
        public void contructorNewInstance(SootMethod source, Stmt s) {
            if (this.options.safe_newinstance()) {
                for (SootMethod tgt : EntryPoints.v().allInits()) {
                    OnFlyCallGraphBuilder.this.addEdge(source, s, tgt, Kind.NEWINSTANCE);
                }
            } else {
                for (SootClass cls : Scene.v().dynamicClasses()) {
                    for (SootMethod m : cls.getMethods()) {
                        if (!m.getName().equals("<init>")) continue;
                        OnFlyCallGraphBuilder.this.addEdge(source, s, m, Kind.NEWINSTANCE);
                    }
                }
                if (this.options.verbose()) {
                    logger.warn("Method " + source + " is reachable, and calls Constructor.newInstance; graph will be incomplete! Use safe-newinstance option for a conservative result.");
                }
            }
        }

        @Override
        public void methodInvoke(SootMethod container2, Stmt invokeStmt) {
            if (!this.warnedAlready(container2)) {
                if (this.options.verbose()) {
                    logger.warn("call to java.lang.reflect.Method: invoke() from " + container2 + "; graph will be incomplete!");
                }
                this.markWarned(container2);
            }
        }

        private void markWarned(SootMethod m) {
            this.warnedAlready.add(m);
        }

        private boolean warnedAlready(SootMethod m) {
            return this.warnedAlready.contains(m);
        }
    }
}

