/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.BodyTransformer;
import soot.G;
import soot.Singletons;
import soot.Unit;
import soot.UnitBox;
import soot.UnitPatchingChain;
import soot.jimple.GotoStmt;
import soot.jimple.Jimple;
import soot.options.Options;
import soot.util.Chain;

public class CriticalEdgeRemover
extends BodyTransformer {
    private static final Logger logger = LoggerFactory.getLogger(CriticalEdgeRemover.class);

    public CriticalEdgeRemover(Singletons.Global g) {
    }

    public static CriticalEdgeRemover v() {
        return G.v().soot_jimple_toolkits_graph_CriticalEdgeRemover();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        if (Options.v().verbose()) {
            logger.debug("[" + b.getMethod().getName() + "]     Removing Critical Edges...");
        }
        this.removeCriticalEdges(b);
        if (Options.v().verbose()) {
            logger.debug("[" + b.getMethod().getName() + "]     Removing Critical Edges done.");
        }
    }

    private static Unit insertGotoAfter(Chain<Unit> unitChain, Unit node, Unit target) {
        GotoStmt newGoto = Jimple.v().newGotoStmt(target);
        unitChain.insertAfter(newGoto, node);
        return newGoto;
    }

    private static Unit insertGotoBefore(Chain<Unit> unitChain, Unit node, Unit target) {
        GotoStmt newGoto = Jimple.v().newGotoStmt(target);
        unitChain.insertBefore(newGoto, node);
        newGoto.redirectJumpsToThisTo(node);
        return newGoto;
    }

    private static void redirectBranch(Unit node, Unit oldTarget, Unit newTarget) {
        for (UnitBox targetBox : node.getUnitBoxes()) {
            Unit target = targetBox.getUnit();
            if (target != oldTarget) continue;
            targetBox.setUnit(newTarget);
        }
    }

    private void removeCriticalEdges(Body b) {
        Unit currentUnit;
        UnitPatchingChain unitChain = b.getUnits();
        int size = unitChain.size();
        HashMap<Unit, ArrayList<Unit>> predecessors = new HashMap<Unit, ArrayList<Unit>>(2 * size + 1, 0.7f);
        Iterator unitIt = unitChain.snapshotIterator();
        while (unitIt.hasNext()) {
            currentUnit = (Unit)unitIt.next();
            Iterator<UnitBox> succsIt = currentUnit.getUnitBoxes().iterator();
            while (succsIt.hasNext()) {
                Unit target = succsIt.next().getUnit();
                ArrayList<Unit> predList = (ArrayList<Unit>)predecessors.get(target);
                if (predList == null) {
                    predList = new ArrayList<Unit>();
                    predList.add(currentUnit);
                    predecessors.put(target, predList);
                    continue;
                }
                predList.add(currentUnit);
            }
        }
        unitIt = unitChain.snapshotIterator();
        currentUnit = null;
        while (unitIt.hasNext()) {
            int nbPreds;
            Unit directPredecessor = currentUnit;
            currentUnit = (Unit)unitIt.next();
            List predList = (List)predecessors.get(currentUnit);
            int n = nbPreds = predList == null ? 0 : predList.size();
            if (directPredecessor != null && directPredecessor.fallsThrough()) {
                ++nbPreds;
            }
            if (nbPreds < 2) continue;
            if (directPredecessor != null && directPredecessor.fallsThrough()) {
                directPredecessor = CriticalEdgeRemover.insertGotoAfter(unitChain, directPredecessor, currentUnit);
            }
            for (Unit predecessor : predList) {
                int nbSuccs = predecessor.getUnitBoxes().size();
                if ((nbSuccs += predecessor.fallsThrough() ? 1 : 0) < 2) continue;
                directPredecessor = directPredecessor == null ? CriticalEdgeRemover.insertGotoBefore(unitChain, currentUnit, currentUnit) : CriticalEdgeRemover.insertGotoAfter(unitChain, directPredecessor, currentUnit);
                CriticalEdgeRemover.redirectBranch(predecessor, currentUnit, directPredecessor);
            }
        }
    }
}

