/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.pointer;

import java.util.HashSet;
import java.util.Set;
import soot.G;
import soot.PointsToSet;
import soot.SootField;
import soot.jimple.toolkits.pointer.RWSet;
import soot.jimple.toolkits.pointer.Union;

public class SiteRWSet
extends RWSet {
    public HashSet<RWSet> sets = new HashSet();
    protected boolean callsNative = false;

    @Override
    public int size() {
        Set globals = this.getGlobals();
        Set fields = this.getFields();
        if (globals == null) {
            if (fields == null) {
                return 0;
            }
            return fields.size();
        }
        if (fields == null) {
            return globals.size();
        }
        return globals.size() + fields.size();
    }

    public String toString() {
        boolean empty = true;
        StringBuffer ret = new StringBuffer();
        ret.append("SiteRWSet: ");
        for (RWSet key : this.sets) {
            ret.append(key.toString());
            empty = false;
        }
        if (empty) {
            ret.append("empty");
        }
        return ret.toString();
    }

    @Override
    public boolean getCallsNative() {
        return this.callsNative;
    }

    @Override
    public boolean setCallsNative() {
        boolean ret = !this.callsNative;
        this.callsNative = true;
        return ret;
    }

    public Set getGlobals() {
        HashSet ret = new HashSet();
        for (RWSet s : this.sets) {
            ret.addAll(s.getGlobals());
        }
        return ret;
    }

    public Set getFields() {
        HashSet ret = new HashSet();
        for (RWSet s : this.sets) {
            ret.addAll(s.getFields());
        }
        return ret;
    }

    @Override
    public PointsToSet getBaseForField(Object f) {
        Union ret = null;
        for (RWSet s : this.sets) {
            PointsToSet os = s.getBaseForField(f);
            if (os == null || os.isEmpty()) continue;
            if (ret == null) {
                ret = G.v().Union_factory.newUnion();
            }
            ret.addAll(os);
        }
        return ret;
    }

    @Override
    public boolean hasNonEmptyIntersection(RWSet oth) {
        if (this.sets.contains(oth)) {
            return true;
        }
        for (RWSet s : this.sets) {
            if (!oth.hasNonEmptyIntersection(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean union(RWSet other) {
        if (other == null) {
            return false;
        }
        boolean ret = false;
        if (other.getCallsNative()) {
            ret = this.setCallsNative();
        }
        if (other.getFields().isEmpty() && other.getGlobals().isEmpty()) {
            return ret;
        }
        return this.sets.add(other) | ret;
    }

    @Override
    public boolean addGlobal(SootField global) {
        throw new RuntimeException("Not implemented; try MethodRWSet");
    }

    @Override
    public boolean addFieldRef(PointsToSet otherBase, Object field) {
        throw new RuntimeException("Not implemented; try MethodRWSet");
    }

    @Override
    public boolean isEquivTo(RWSet other) {
        if (!(other instanceof SiteRWSet)) {
            return false;
        }
        SiteRWSet o = (SiteRWSet)other;
        if (o.callsNative != this.callsNative) {
            return false;
        }
        return o.sets.equals(this.sets);
    }
}

