/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.scalar;

import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.Body;
import soot.G;
import soot.Local;
import soot.Scene;
import soot.Singletons;
import soot.SootMethod;
import soot.Unit;
import soot.ValueBox;
import soot.jimple.InvokeExpr;
import soot.jimple.StaticInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.toolkits.scalar.AbstractStaticnessCorrector;

public class MethodStaticnessCorrector
extends AbstractStaticnessCorrector {
    private static final Logger logger = LoggerFactory.getLogger(MethodStaticnessCorrector.class);

    public MethodStaticnessCorrector(Singletons.Global g) {
    }

    public static MethodStaticnessCorrector v() {
        return G.v().soot_jimple_toolkits_scalar_MethodStaticnessCorrector();
    }

    @Override
    protected void internalTransform(Body b, String phaseName, Map<String, String> options) {
        Iterator unitIt = b.getUnits().snapshotIterator();
        while (unitIt.hasNext()) {
            SootMethod target;
            InvokeExpr iexpr;
            Stmt s;
            Unit u = (Unit)unitIt.next();
            if (!(u instanceof Stmt) || !(s = (Stmt)u).containsInvokeExpr() || !((iexpr = s.getInvokeExpr()) instanceof StaticInvokeExpr) || !this.isClassLoaded(iexpr.getMethodRef().declaringClass()) || (target = Scene.v().grabMethod(iexpr.getMethodRef().getSignature())) == null || target.isStatic() || !this.canBeMadeStatic(target)) continue;
            target.getActiveBody().getUnits().remove(target.getActiveBody().getThisUnit());
            target.setModifiers(target.getModifiers() | 8);
            logger.warn(target.getName() + " changed into a static method");
        }
    }

    private boolean canBeMadeStatic(SootMethod target) {
        if (target.hasActiveBody()) {
            Body body = target.getActiveBody();
            Local thisLocal = body.getThisLocal();
            for (Unit u : body.getUnits()) {
                for (ValueBox vb : u.getUseBoxes()) {
                    if (vb.getValue() != thisLocal) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }
}

