/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.toolkits.thread.mhp;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.ArraySparseSet;
import soot.toolkits.scalar.FlowSet;
import soot.util.Chain;

public class DominatorsFinder {
    private final Map<Object, FlowSet> unitToDominators = new HashMap<Object, FlowSet>();
    private final DirectedGraph peg;

    DominatorsFinder(Chain chain, DirectedGraph pegGraph) {
        this.peg = pegGraph;
        this.find(chain);
    }

    private void find(Chain chain) {
        boolean change = true;
        ArraySparseSet<Object> fullSet = new ArraySparseSet<Object>();
        ArraySparseSet temp = new ArraySparseSet();
        Iterator chainIt = chain.iterator();
        while (chainIt.hasNext()) {
            fullSet.add(chainIt.next());
        }
        List heads = this.peg.getHeads();
        if (heads.size() != 1) {
            throw new RuntimeException("The size of heads of peg is not equal to 1!");
        }
        ArraySparseSet dominators = new ArraySparseSet();
        Object head = heads.get(0);
        dominators.add(head);
        this.unitToDominators.put(head, dominators);
        for (Object n : chain) {
            if (heads.contains(n)) continue;
            ArraySparseSet domin = new ArraySparseSet();
            fullSet.copy(domin);
            this.unitToDominators.put(n, domin);
        }
        System.out.println("===finish init unitToDominators===");
        System.err.println("===finish init unitToDominators===");
        do {
            change = false;
            for (Object n : chain) {
                if (heads.contains(n)) continue;
                fullSet.copy(temp);
                for (Object p : this.peg.getPredsOf(n)) {
                    FlowSet dom = this.getDominatorsOf(p);
                    temp.intersection(dom);
                }
                ArraySparseSet d = new ArraySparseSet();
                ArraySparseSet<Object> nSet = new ArraySparseSet<Object>();
                nSet.add(n);
                nSet.union(temp, d);
                ArraySparseSet dominN = this.getDominatorsOf(n);
                if (((Object)d).equals(dominN)) continue;
                change = true;
                dominN = d;
            }
        } while (!change);
    }

    public FlowSet getDominatorsOf(Object s) {
        if (!this.unitToDominators.containsKey(s)) {
            throw new RuntimeException("Invalid stmt" + s);
        }
        return this.unitToDominators.get(s);
    }
}

