/*
 * Decompiled with CFR 0.152.
 */
package soot.tagkit;

import soot.jimple.FloatConstant;
import soot.tagkit.ConstantValueTag;

public class FloatConstantValueTag
extends ConstantValueTag {
    private final float value;

    public FloatConstantValueTag(float value) {
        this.value = value;
    }

    public float getFloatValue() {
        return this.value;
    }

    @Override
    public String toString() {
        return "ConstantValue: " + Float.toString(this.value);
    }

    @Override
    public FloatConstant getConstant() {
        return FloatConstant.v(this.value);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Float.floatToIntBits(this.value);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FloatConstantValueTag other = (FloatConstantValueTag)obj;
        return Float.floatToIntBits(this.value) == Float.floatToIntBits(other.value);
    }
}

