/*
 * Decompiled with CFR 0.152.
 */
package soot.toolkits.scalar;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import soot.toolkits.scalar.AbstractBoundedFlowSet;
import soot.toolkits.scalar.FlowSet;
import soot.toolkits.scalar.FlowUniverse;
import soot.toolkits.scalar.ObjectIntMapper;

public class ArrayPackedSet<T>
extends AbstractBoundedFlowSet<T> {
    ObjectIntMapper<T> map;
    BitSet bits;

    public ArrayPackedSet(FlowUniverse<T> universe) {
        this(new ObjectIntMapper<T>(universe));
    }

    ArrayPackedSet(ObjectIntMapper<T> map) {
        this(map, new BitSet());
    }

    ArrayPackedSet(ObjectIntMapper<T> map, BitSet bits) {
        this.map = map;
        this.bits = bits;
    }

    @Override
    public ArrayPackedSet<T> clone() {
        return new ArrayPackedSet<T>(this.map, (BitSet)this.bits.clone());
    }

    @Override
    public FlowSet<T> emptySet() {
        return new ArrayPackedSet<T>(this.map);
    }

    @Override
    public int size() {
        return this.bits.cardinality();
    }

    @Override
    public boolean isEmpty() {
        return this.bits.isEmpty();
    }

    @Override
    public void clear() {
        this.bits.clear();
    }

    private BitSet copyBitSet(ArrayPackedSet<?> dest) {
        assert (dest.map == this.map);
        if (this != dest) {
            dest.bits.clear();
            dest.bits.or(this.bits);
        }
        return dest.bits;
    }

    private boolean sameType(Object flowSet) {
        if (flowSet instanceof ArrayPackedSet) {
            return ((ArrayPackedSet)flowSet).map == this.map;
        }
        return false;
    }

    private List<T> toList(BitSet bits, int base) {
        int len = bits.cardinality();
        switch (len) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(this.map.getObject(base - 1 + bits.length()));
            }
        }
        ArrayList<T> elements = new ArrayList<T>(len);
        int i = bits.nextSetBit(0);
        do {
            int endOfRun = bits.nextClearBit(i + 1);
            do {
                elements.add(this.map.getObject(base + i++));
            } while (i < endOfRun);
        } while ((i = bits.nextSetBit(i + 1)) >= 0);
        return elements;
    }

    public List<T> toList(int lowInclusive, int highInclusive) {
        if (lowInclusive > highInclusive) {
            return Collections.emptyList();
        }
        int highExclusive = highInclusive + 1;
        if (lowInclusive < 0) {
            throw new IllegalArgumentException();
        }
        return this.toList(this.bits.get(lowInclusive, highExclusive), lowInclusive);
    }

    @Override
    public List<T> toList() {
        return this.toList(this.bits, 0);
    }

    @Override
    public void add(T obj) {
        this.bits.set(this.map.getInt(obj));
    }

    @Override
    public void complement(FlowSet<T> destFlow) {
        if (this.sameType(destFlow)) {
            ArrayPackedSet dest = (ArrayPackedSet)destFlow;
            this.copyBitSet(dest).flip(0, dest.map.size());
        } else {
            super.complement(destFlow);
        }
    }

    @Override
    public void remove(T obj) {
        this.bits.clear(this.map.getInt(obj));
    }

    @Override
    public boolean isSubSet(FlowSet<T> other) {
        if (other == this) {
            return true;
        }
        if (this.sameType(other)) {
            ArrayPackedSet o = (ArrayPackedSet)other;
            BitSet tmp = (BitSet)o.bits.clone();
            tmp.andNot(this.bits);
            return tmp.isEmpty();
        }
        return super.isSubSet(other);
    }

    @Override
    public void union(FlowSet<T> otherFlow, FlowSet<T> destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            ArrayPackedSet other = (ArrayPackedSet)otherFlow;
            ArrayPackedSet dest = (ArrayPackedSet)destFlow;
            this.copyBitSet(dest).or(other.bits);
        } else {
            super.union(otherFlow, destFlow);
        }
    }

    @Override
    public void difference(FlowSet<T> otherFlow, FlowSet<T> destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            ArrayPackedSet other = (ArrayPackedSet)otherFlow;
            ArrayPackedSet dest = (ArrayPackedSet)destFlow;
            this.copyBitSet(dest).andNot(other.bits);
        } else {
            super.difference(otherFlow, destFlow);
        }
    }

    @Override
    public void intersection(FlowSet<T> otherFlow, FlowSet<T> destFlow) {
        if (this.sameType(otherFlow) && this.sameType(destFlow)) {
            ArrayPackedSet other = (ArrayPackedSet)otherFlow;
            ArrayPackedSet dest = (ArrayPackedSet)destFlow;
            this.copyBitSet(dest).and(other.bits);
        } else {
            super.intersection(otherFlow, destFlow);
        }
    }

    @Override
    public boolean contains(T obj) {
        return this.map.contains(obj) && this.bits.get(this.map.getInt(obj));
    }

    @Override
    public boolean equals(Object otherFlow) {
        if (this.sameType(otherFlow)) {
            return this.bits.equals(((ArrayPackedSet)otherFlow).bits);
        }
        return super.equals(otherFlow);
    }

    @Override
    public void copy(FlowSet<T> destFlow) {
        if (this == destFlow) {
            return;
        }
        if (this.sameType(destFlow)) {
            ArrayPackedSet dest = (ArrayPackedSet)destFlow;
            this.copyBitSet(dest);
        } else {
            super.copy(destFlow);
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int curr = -1;
            int next;
            {
                this.next = ArrayPackedSet.this.bits.nextSetBit(0);
            }

            @Override
            public boolean hasNext() {
                return this.next >= 0;
            }

            @Override
            public T next() {
                if (this.next < 0) {
                    throw new NoSuchElementException();
                }
                this.curr = this.next;
                this.next = ArrayPackedSet.this.bits.nextSetBit(this.curr + 1);
                return ArrayPackedSet.this.map.getObject(this.curr);
            }

            @Override
            public void remove() {
                if (this.curr < 0) {
                    throw new IllegalStateException();
                }
                ArrayPackedSet.this.bits.clear(this.curr);
                this.curr = -1;
            }
        };
    }
}

