/*
 * Decompiled with CFR 0.152.
 */
package soot.util;

import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import soot.util.IterableNumberer;
import soot.util.Numberable;

public class ArrayNumberer<E extends Numberable>
implements IterableNumberer<E> {
    protected E[] numberToObj;
    protected int lastNumber;
    protected BitSet freeNumbers;

    public ArrayNumberer() {
        this.numberToObj = new Numberable[1024];
        this.lastNumber = 0;
    }

    public ArrayNumberer(E[] elements) {
        this.numberToObj = elements;
        this.lastNumber = elements.length;
    }

    private void resize(int n) {
        this.numberToObj = (Numberable[])Arrays.copyOf(this.numberToObj, n);
    }

    @Override
    public synchronized void add(E o) {
        int ns;
        if (o.getNumber() != 0) {
            return;
        }
        int chosenNumber = -1;
        if (this.freeNumbers != null && (ns = this.freeNumbers.nextSetBit(0)) != -1) {
            chosenNumber = ns;
            this.freeNumbers.clear(ns);
        }
        if (chosenNumber == -1) {
            chosenNumber = ++this.lastNumber;
        }
        if (this.lastNumber >= this.numberToObj.length) {
            this.resize(this.numberToObj.length * 2);
        }
        this.numberToObj[this.lastNumber] = o;
        o.setNumber(this.lastNumber);
    }

    @Override
    public long get(E o) {
        if (o == null) {
            return 0L;
        }
        int ret = o.getNumber();
        if (ret == 0) {
            throw new RuntimeException("unnumbered: " + o);
        }
        return ret;
    }

    @Override
    public E get(long number) {
        if (number == 0L) {
            return null;
        }
        E ret = this.numberToObj[(int)number];
        if (ret == null) {
            throw new RuntimeException("no object with number " + number);
        }
        return ret;
    }

    @Override
    public int size() {
        return this.lastNumber;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int cur = 1;

            @Override
            public final boolean hasNext() {
                return this.cur <= ArrayNumberer.this.lastNumber && this.cur < ArrayNumberer.this.numberToObj.length && ArrayNumberer.this.numberToObj[this.cur] != null;
            }

            @Override
            public final E next() {
                if (this.hasNext()) {
                    return ArrayNumberer.this.numberToObj[this.cur++];
                }
                throw new NoSuchElementException();
            }

            @Override
            public final void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean remove(E o) {
        if (o == null) {
            return false;
        }
        int num = o.getNumber();
        if (num == 0) {
            return false;
        }
        if (this.freeNumbers == null) {
            this.freeNumbers = new BitSet(2 * num);
        }
        this.numberToObj[num] = null;
        o.setNumber(0);
        this.freeNumbers.set(num);
        return true;
    }
}

