/*
 * Decompiled with CFR 0.152.
 */
package soot.util.queue;

import java.util.Iterator;
import java.util.NoSuchElementException;
import soot.util.queue.ChunkedQueue;

public class QueueReader<E>
implements Iterator<E> {
    private E[] q;
    private int index;

    protected QueueReader(E[] q, int index) {
        this.q = q;
        this.index = index;
    }

    @Override
    public E next() {
        E ret = null;
        do {
            if (this.q[this.index] == null) {
                throw new NoSuchElementException();
            }
            if (this.index == this.q.length - 1) {
                this.q = (Object[])this.q[this.index];
                this.index = 0;
                if (this.q[this.index] == null) {
                    throw new NoSuchElementException();
                }
            }
            if ((ret = (E)this.q[this.index]) == ChunkedQueue.NULL_CONST) {
                ret = null;
            }
            ++this.index;
        } while (ret == ChunkedQueue.DELETED_CONST);
        return ret;
    }

    @Override
    public boolean hasNext() {
        while (true) {
            if (this.q[this.index] == null) {
                return false;
            }
            if (this.index == this.q.length - 1) {
                this.q = (Object[])this.q[this.index];
                this.index = 0;
                if (this.q[this.index] == null) {
                    return false;
                }
            }
            if (this.q[this.index] != ChunkedQueue.DELETED_CONST) break;
            ++this.index;
        }
        return true;
    }

    public void remove(E o) {
        int idx = 0;
        Object[] curQ = this.q;
        while (curQ[idx] != null) {
            if (idx == curQ.length - 1) {
                curQ = (Object[])curQ[idx];
                idx = 0;
            }
            if (o.equals(curQ[idx])) {
                curQ[idx] = ChunkedQueue.DELETED_CONST;
            }
            ++idx;
        }
    }

    @Override
    public void remove() {
        this.q[this.index - 1] = ChunkedQueue.DELETED_CONST;
    }

    public QueueReader<E> clone() {
        return new QueueReader<E>(this.q, this.index);
    }
}

