/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.functionfit;

import umontreal.ssj.functions.MathFunction;
import umontreal.ssj.functions.MathFunctionWithDerivative;
import umontreal.ssj.functions.MathFunctionWithFirstDerivative;
import umontreal.ssj.functions.MathFunctionWithIntegral;
import umontreal.ssj.functions.Polynomial;

public class SmoothingCubicSpline
implements MathFunction,
MathFunctionWithFirstDerivative,
MathFunctionWithDerivative,
MathFunctionWithIntegral {
    private Polynomial[] splineVector;
    private double[] x;
    private double[] y;
    private double[] weight;
    private double rho;

    public SmoothingCubicSpline(double[] x, double[] y, double[] w, double rho) {
        if (x.length != y.length) {
            throw new IllegalArgumentException("x.length != y.length");
        }
        if (w != null && x.length != w.length) {
            throw new IllegalArgumentException("x.length != w.length");
        }
        if (rho < 0.0 || rho > 1.0) {
            throw new IllegalArgumentException("rho not in [0, 1]");
        }
        this.splineVector = new Polynomial[x.length + 1];
        this.rho = rho;
        this.x = (double[])x.clone();
        this.y = (double[])y.clone();
        this.weight = new double[x.length];
        if (w == null) {
            for (int i = 0; i < this.weight.length; ++i) {
                this.weight[i] = 1.0;
            }
        } else {
            for (int i = 0; i < this.weight.length; ++i) {
                this.weight[i] = w[i];
            }
        }
        this.resolve();
    }

    public SmoothingCubicSpline(double[] x, double[] y, double rho) {
        this(x, y, null, rho);
    }

    @Override
    public double evaluate(double z) {
        int i = this.getFitPolynomialIndex(z);
        if (i == 0) {
            return this.splineVector[i].evaluate(z - this.x[0]);
        }
        return this.splineVector[i].evaluate(z - this.x[i - 1]);
    }

    @Override
    public double integral(double a, double b) {
        double retour;
        int iA = this.getFitPolynomialIndex(a);
        int iB = this.getFitPolynomialIndex(b);
        int i = 1;
        if (iA == iB) {
            retour = this.splineVector[iB].integral(a - this.x[iB], b - this.x[iB]);
        } else {
            retour = iA == 0 ? this.splineVector[iA].integral(a - this.x[iA], 0.0) : this.splineVector[iA].integral(a - this.x[iA], this.x[iA + 1] - this.x[iA]);
            for (i = iA + 1; i < iB; ++i) {
                retour += this.splineVector[i].integral(0.0, this.x[i + 1] - this.x[i]);
            }
            retour += this.splineVector[iB].integral(0.0, b - this.x[iB]);
        }
        return retour;
    }

    @Override
    public double derivative(double z) {
        int i = this.getFitPolynomialIndex(z);
        if (i == 0) {
            return this.splineVector[i].derivative(z - this.x[0]);
        }
        return this.splineVector[i].derivative(z - this.x[i - 1]);
    }

    @Override
    public double derivative(double z, int n) {
        int i = this.getFitPolynomialIndex(z);
        if (i == 0) {
            return this.splineVector[i].derivative(z - this.x[0], n);
        }
        return this.splineVector[i].derivative(z - this.x[i - 1], n);
    }

    public double[] getX() {
        return (double[])this.x.clone();
    }

    public double[] getY() {
        return (double[])this.y.clone();
    }

    public double[] getWeights() {
        return this.weight;
    }

    public double getRho() {
        return this.rho;
    }

    public Polynomial[] getSplinePolynomials() {
        return (Polynomial[])this.splineVector.clone();
    }

    public int getFitPolynomialIndex(double x) {
        int j = this.x.length - 1;
        if (x > this.x[j]) {
            return j + 1;
        }
        int tmp = 0;
        int i = 0;
        while (i + 1 != j) {
            if (x > this.x[tmp]) {
                i = tmp;
                tmp = i + (j - i) / 2;
            } else {
                j = tmp;
                tmp = i + (j - i) / 2;
            }
            if (j != 0) continue;
            --i;
        }
        return i + 1;
    }

    private void resolve() {
        int j;
        int i;
        double[] h = new double[this.x.length];
        double[] r = new double[this.x.length];
        double[] u = new double[this.x.length];
        double[] v = new double[this.x.length];
        double[] w = new double[this.x.length];
        double[] q = new double[this.x.length + 1];
        double[] sigma = new double[this.weight.length];
        for (int i2 = 0; i2 < this.weight.length; ++i2) {
            sigma[i2] = this.weight[i2] <= 0.0 ? 1.0E100 : 1.0 / Math.sqrt(this.weight[i2]);
        }
        int n = this.x.length - 1;
        double mu = this.rho <= 0.0 ? 1.0E100 : 2.0 * (1.0 - this.rho) / (3.0 * this.rho);
        h[0] = this.x[1] - this.x[0];
        r[0] = 3.0 / h[0];
        for (i = 1; i < n; ++i) {
            h[i] = this.x[i + 1] - this.x[i];
            r[i] = 3.0 / h[i];
            q[i] = 3.0 * (this.y[i + 1] - this.y[i]) / h[i] - 3.0 * (this.y[i] - this.y[i - 1]) / h[i - 1];
        }
        for (i = 1; i < n; ++i) {
            u[i] = r[i - 1] * r[i - 1] * sigma[i - 1] + (r[i - 1] + r[i]) * (r[i - 1] + r[i]) * sigma[i] + r[i] * r[i] * sigma[i + 1];
            u[i] = mu * u[i] + 2.0 * (this.x[i + 1] - this.x[i - 1]);
            v[i] = -(r[i - 1] + r[i]) * r[i] * sigma[i] - r[i] * (r[i] + r[i + 1]) * sigma[i + 1];
            v[i] = mu * v[i] + h[i];
            w[i] = mu * r[i] * r[i + 1] * sigma[i + 1];
        }
        q = SmoothingCubicSpline.Quincunx(u, v, w, q);
        double[] params = new double[4];
        params[0] = this.y[0] - mu * r[0] * q[1] * sigma[0];
        double dd = this.y[1] - mu * ((-r[0] - r[1]) * q[1] + r[1] * q[2]) * sigma[1];
        params[1] = (dd - params[0]) / h[0] - q[1] * h[0] / 3.0;
        this.splineVector[0] = new Polynomial(params);
        params[0] = this.y[0] - mu * r[0] * q[1] * sigma[0];
        dd = this.y[1] - mu * ((-r[0] - r[1]) * q[1] + r[1] * q[2]) * sigma[1];
        params[3] = q[1] / (3.0 * h[0]);
        params[2] = 0.0;
        params[1] = (dd - params[0]) / h[0] - q[1] * h[0] / 3.0;
        this.splineVector[1] = new Polynomial(params);
        for (j = 1; j < n; ++j) {
            params[3] = (q[j + 1] - q[j]) / (3.0 * h[j]);
            params[2] = q[j];
            params[1] = (q[j] + q[j - 1]) * h[j - 1] + this.splineVector[j].getCoefficient(1);
            params[0] = r[j - 1] * q[j - 1] + (-r[j - 1] - r[j]) * q[j] + r[j] * q[j + 1];
            params[0] = this.y[j] - mu * params[0] * sigma[j];
            this.splineVector[j + 1] = new Polynomial(params);
        }
        j = n;
        params[3] = 0.0;
        params[2] = 0.0;
        params[1] = this.splineVector[j].derivative(this.x[this.x.length - 1] - this.x[this.x.length - 2]);
        params[0] = this.splineVector[j].evaluate(this.x[this.x.length - 1] - this.x[this.x.length - 2]);
        this.splineVector[n + 1] = new Polynomial(params);
    }

    private static double[] Quincunx(double[] u, double[] v, double[] w, double[] q) {
        int j;
        u[0] = 0.0;
        v[1] = v[1] / u[1];
        w[1] = w[1] / u[1];
        for (j = 2; j < u.length - 1; ++j) {
            u[j] = u[j] - u[j - 2] * w[j - 2] * w[j - 2] - u[j - 1] * v[j - 1] * v[j - 1];
            v[j] = (v[j] - u[j - 1] * v[j - 1] * w[j - 1]) / u[j];
            w[j] = w[j] / u[j];
        }
        q[1] = q[1] - v[0] * q[0];
        for (j = 2; j < u.length - 1; ++j) {
            q[j] = q[j] - v[j - 1] * q[j - 1] - w[j - 2] * q[j - 2];
        }
        for (j = 1; j < u.length - 1; ++j) {
            q[j] = q[j] / u[j];
        }
        q[u.length - 1] = 0.0;
        for (j = u.length - 3; j > 0; --j) {
            q[j] = q[j] - v[j] * q[j + 1] - w[j] * q[j + 2];
        }
        return q;
    }
}

