/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.GammaDist;
import umontreal.ssj.randvar.RandomVariateGen;
import umontreal.ssj.rng.RandomStream;

public class GammaGen
extends RandomVariateGen {
    protected double alpha = -1.0;
    protected double lambda = -1.0;

    public GammaGen(RandomStream s, double alpha, double lambda) {
        super(s, new GammaDist(alpha, lambda));
        this.setParams(alpha, lambda);
    }

    public GammaGen(RandomStream s, double alpha) {
        this(s, alpha, 1.0);
    }

    public GammaGen(RandomStream s, GammaDist dist) {
        super(s, dist);
        if (dist != null) {
            this.setParams(dist.getAlpha(), dist.getLambda());
        }
    }

    public static double nextDouble(RandomStream s, double alpha, double lambda) {
        return GammaDist.inverseF(alpha, lambda, 15, s.nextDouble());
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getLambda() {
        return this.lambda;
    }

    protected void setParams(double alpha, double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        this.lambda = lambda;
        this.alpha = alpha;
    }
}

