/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.rng;

import java.io.Serializable;
import umontreal.ssj.rng.CloneableRandomStream;

public abstract class RandomStreamBase
implements CloneableRandomStream,
Serializable {
    private static final long serialVersionUID = 70510L;
    protected static double invtwo24 = 5.960464477539063E-8;
    private static double EPSILON = 5.551115123125783E-17;
    protected String name = null;
    protected boolean prec53 = false;
    protected boolean anti = false;

    @Override
    public abstract void resetStartStream();

    @Override
    public abstract void resetStartSubstream();

    @Override
    public abstract void resetNextSubstream();

    @Override
    public abstract String toString();

    public void increasedPrecision(boolean incp) {
        this.prec53 = incp;
    }

    protected abstract double nextValue();

    @Override
    public double nextDouble() {
        double u = this.nextValue();
        if (this.prec53) {
            u = (u + this.nextValue() * invtwo24) % 1.0 + EPSILON;
        }
        if (this.anti) {
            return 1.0 - u;
        }
        return u;
    }

    @Override
    public void nextArrayOfDouble(double[] u, int start, int n) {
        if (u.length == 0) {
            throw new NullPointerException("The array must be initialized.");
        }
        if (u.length < n + start) {
            throw new IndexOutOfBoundsException("The array is too small.");
        }
        if (start < 0) {
            throw new IndexOutOfBoundsException("Must start at a non-negative index.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Must have a non-negative number of elements.");
        }
        for (int ii = start; ii < start + n; ++ii) {
            u[ii] = this.nextDouble();
        }
    }

    @Override
    public int nextInt(int i, int j) {
        if (i > j) {
            throw new IllegalArgumentException(i + " is larger than " + j + ".");
        }
        return i + (int)(this.nextDouble() * ((double)(j - i) + 1.0));
    }

    @Override
    public void nextArrayOfInt(int i, int j, int[] u, int start, int n) {
        if (u == null) {
            throw new NullPointerException("The array must be initialized.");
        }
        if (u.length < n + start) {
            throw new IndexOutOfBoundsException("The array is too small.");
        }
        if (start < 0) {
            throw new IndexOutOfBoundsException("Must start at a non-negative index.");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Must have a non-negative number of elements.");
        }
        for (int ii = start; ii < start + n; ++ii) {
            u[ii] = this.nextInt(i, j);
        }
    }

    @Deprecated
    public String formatState() {
        return this.toString();
    }

    @Deprecated
    public String formatStateFull() {
        throw new UnsupportedOperationException("   call the toStringFull() method instead.");
    }

    @Override
    public RandomStreamBase clone() {
        RandomStreamBase retour = null;
        try {
            retour = (RandomStreamBase)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            cnse.printStackTrace(System.err);
        }
        return retour;
    }
}

