/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.markovchainrqmc;

import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.Array;
import umontreal.ssj.charts.XYLineChart;
import umontreal.ssj.functionfit.LeastSquares;
import umontreal.ssj.hups.CachedPointSet;
import umontreal.ssj.hups.PointSet;
import umontreal.ssj.hups.PointSetIterator;
import umontreal.ssj.hups.PointSetRandomization;
import umontreal.ssj.markovchainrqmc.MarkovChain;
import umontreal.ssj.markovchainrqmc.MarkovChainComparable;
import umontreal.ssj.stat.Tally;
import umontreal.ssj.util.Chrono;
import umontreal.ssj.util.Num;
import umontreal.ssj.util.PrintfFormat;
import umontreal.ssj.util.sort.MultiDimSort;

public class ArrayOfComparableChains<T extends MarkovChainComparable> {
    protected T baseChain;
    protected int n;
    protected T[] chains;
    protected double[] performances;
    protected PointSetRandomization randomization;
    protected MultiDimSort<T> savedSort;
    protected int sortCoordPts = 0;

    public ArrayOfComparableChains(T baseChain) {
        this.baseChain = baseChain;
    }

    public ArrayOfComparableChains(T baseChain, PointSetRandomization rand, MultiDimSort sort) {
        this.baseChain = baseChain;
        this.randomization = rand;
        this.savedSort = sort;
    }

    public void makeCopies(int n) {
        MarkovChainComparable[] c = (MarkovChainComparable[])Array.newInstance(this.baseChain.getClass(), n);
        this.chains = c;
        this.n = n;
        this.performances = new double[n];
        for (int i = 0; i < n; ++i) {
            try {
                this.chains[i] = (MarkovChainComparable)((MarkovChain)this.baseChain).clone();
                continue;
            }
            catch (CloneNotSupportedException e) {
                System.err.println("ArrayOfComparableChains:");
                e.printStackTrace();
            }
        }
    }

    public void initialStates() {
        int i = 0;
        for (T mc : this.chains) {
            ((MarkovChain)mc).initialState();
            this.performances[i] = ((MarkovChain)mc).getPerformance();
            ++i;
        }
    }

    public int getN() {
        return this.n;
    }

    public T[] getChains() {
        return this.chains;
    }

    public void setRandomization(PointSetRandomization rand) {
        this.randomization = rand;
    }

    public PointSetRandomization getRandomization() {
        return this.randomization;
    }

    public void setSort(MultiDimSort sort) {
        this.savedSort = sort;
    }

    public MultiDimSort getSort() {
        return this.savedSort;
    }

    public int simulOneStepArrayRQMC(PointSet p, PointSetRandomization rand, MultiDimSort sort, int sortCoordPts) {
        int nStopped = 0;
        p.randomize(rand);
        if (sortCoordPts > 0) {
            if (!(p instanceof CachedPointSet)) {
                throw new IllegalArgumentException("p is not a CachedPointSet.");
            }
            if (sortCoordPts > 1) {
                ((CachedPointSet)p).sort(sort);
            } else {
                ((CachedPointSet)p).sortByCoordinate(0);
            }
        }
        PointSetIterator stream = p.iterator();
        stream.resetCurPointIndex();
        int i = 0;
        for (T mc : this.chains) {
            if (((MarkovChain)mc).hasStopped()) {
                ++nStopped;
            } else {
                stream.setCurCoordIndex(sortCoordPts);
                ((MarkovChain)mc).nextStep(stream);
                stream.resetNextSubstream();
                if (((MarkovChain)mc).hasStopped()) {
                    ++nStopped;
                }
            }
            this.performances[i] = ((MarkovChain)mc).getPerformance();
            ++i;
        }
        return this.n - nStopped;
    }

    public int simulOneStepArrayRQMC(PointSet p) {
        return this.simulOneStepArrayRQMC(p, this.randomization, this.savedSort, 0);
    }

    public double simulArrayRQMC(PointSet p, PointSetRandomization rand, MultiDimSort sort, int sortCoordPts, int numSteps) {
        int numNotStopped = this.n;
        this.initialStates();
        for (int step = 0; step < numSteps && numNotStopped > 0; ++step) {
            if (numNotStopped == this.n) {
                sort.sort(this.chains, 0, this.n);
            } else {
                this.sortNotStoppedChains(sort);
            }
            p.randomize(rand);
            if (sortCoordPts > 0) {
                if (!(p instanceof CachedPointSet)) {
                    throw new IllegalArgumentException("p is not a CachedPointSet.");
                }
                if (sortCoordPts > 1) {
                    ((CachedPointSet)p).sort(sort);
                } else {
                    ((CachedPointSet)p).sortByCoordinate(0);
                }
            }
            PointSetIterator stream = p.iterator();
            stream.resetCurPointIndex();
            int i = 0;
            for (T mc : this.chains) {
                if (((MarkovChain)mc).hasStopped()) {
                    --numNotStopped;
                } else {
                    stream.setCurCoordIndex(sortCoordPts);
                    ((MarkovChain)mc).nextStep(stream);
                    stream.resetNextSubstream();
                    if (((MarkovChain)mc).hasStopped()) {
                        --numNotStopped;
                    }
                }
                this.performances[i] = ((MarkovChain)mc).getPerformance();
                ++i;
            }
        }
        return this.calcMeanPerf();
    }

    public double simulArrayRQMC(PointSet p, PointSetRandomization rand, MultiDimSort sort, int numSteps) {
        return this.simulArrayRQMC(p, rand, sort, 0, numSteps);
    }

    public double simulArrayRQMC(PointSet p, int numSteps) {
        return this.simulArrayRQMC(p, this.randomization, this.savedSort, 0, numSteps);
    }

    public double[] getPerformances() {
        return this.performances;
    }

    public double calcMeanPerf() {
        double sumPerf = 0.0;
        for (int i = 0; i < this.n; ++i) {
            sumPerf += this.performances[i];
        }
        return sumPerf / (double)this.n;
    }

    public void simulReplicatesArrayRQMC(PointSet p, PointSetRandomization rand, MultiDimSort sort, int sortCoordPts, int numSteps, int m, Tally statReps) {
        this.makeCopies(p.getNumPoints());
        statReps.init();
        for (int rep = 0; rep < m; ++rep) {
            statReps.add(this.simulArrayRQMC(p, rand, sort, sortCoordPts, numSteps));
        }
    }

    public String simulReplicatesArrayRQMCFormat(PointSet p, PointSetRandomization rand, MultiDimSort sort, int sortCoordPts, int numSteps, int m, Tally statReps) {
        Chrono timer = Chrono.createForSingleThread();
        this.makeCopies(p.getNumPoints());
        timer.init();
        statReps.init();
        for (int rep = 0; rep < m; ++rep) {
            statReps.add(this.simulArrayRQMC(p, rand, sort, sortCoordPts, numSteps));
        }
        StringBuffer sb = new StringBuffer("----------------------------------------------" + PrintfFormat.NEWLINE);
        sb.append("Array-RQMC simulations:" + PrintfFormat.NEWLINE);
        sb.append(PrintfFormat.NEWLINE + p.toString() + ":" + PrintfFormat.NEWLINE);
        sb.append(" Number of indep copies m  = " + m);
        sb.append(PrintfFormat.NEWLINE + " Number of points n        = " + this.n + PrintfFormat.NEWLINE);
        sb.append(((MarkovChain)this.baseChain).formatResultsRQMC(statReps, this.n));
        sb.append(" CPU Time = " + timer.format() + PrintfFormat.NEWLINE);
        return sb.toString();
    }

    public String varianceImprovementFormat(double varRQMC, double varMC) {
        StringBuffer sb = new StringBuffer(" Variance ratio MC / RQMC: " + PrintfFormat.format(15, 10, 4, varMC / varRQMC) + PrintfFormat.NEWLINE);
        return sb.toString();
    }

    public String testVarianceRateFormat(PointSet[] pointSets, PointSetRandomization rand, MultiDimSort sort, int sortCoordPts, int numSteps, int m, double varMC, String filenamePlot, String methodLabel) {
        int numSets = pointSets.length;
        Tally statPerf = new Tally("Performance");
        double[] logn = new double[numSets];
        double[] variance = new double[numSets];
        double[] logVariance = new double[numSets];
        StringBuffer str = new StringBuffer("\n\n --------------------------");
        str.append(methodLabel + "\n  MC Variance : " + varMC + "\n\n");
        for (int i = 0; i < numSets; ++i) {
            long initTime = System.currentTimeMillis();
            this.n = pointSets[i].getNumPoints();
            str.append("n = " + this.n + "\n");
            this.simulReplicatesArrayRQMC(pointSets[i], rand, sort, sortCoordPts, numSteps, m, statPerf);
            logn[i] = Num.log2(this.n);
            variance[i] = statPerf.variance();
            logVariance[i] = Num.log2(variance[i]);
            str.append("  Average = " + statPerf.average() + "\n");
            str.append("  VRF =  " + varMC / ((double)this.n * variance[i]) + "\n");
            str.append(this.formatTime((double)(System.currentTimeMillis() - initTime) / 1000.0) + "\n");
        }
        double regSlope = this.slope(logn, logVariance, numSets);
        str.append("Regression slope (log) for variance = " + regSlope + "\n\n");
        if (filenamePlot != null) {
            try {
                FileWriter file = new FileWriter(filenamePlot + ".tex");
                XYLineChart chart = new XYLineChart();
                chart.add(logn, logVariance);
                file.write(chart.toLatex(12.0, 8.0));
                ((Writer)file).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return str.toString();
    }

    public void sortNotStoppedChains(MultiDimSort sort) {
        int j;
        int i = 0;
        for (j = this.n - 1; j >= 0 && ((MarkovChain)this.chains[j]).hasStopped(); --j) {
        }
        while (i < this.n && !((MarkovChain)this.chains[i]).hasStopped()) {
            ++i;
        }
        while (i < j) {
            while (!((MarkovChain)this.chains[i]).hasStopped()) {
                ++i;
            }
            while (((MarkovChain)this.chains[j]).hasStopped()) {
                --j;
            }
            T mc = this.chains[i];
            this.chains[i] = this.chains[j];
            this.chains[j] = mc;
        }
        sort.sort(this.chains, 0, i);
    }

    public void sortChains() {
        this.savedSort.sort(this.chains, 0, this.n);
    }

    public String formatTime(double time) {
        int min;
        int hour = (int)(time / 3600.0);
        if (hour > 0) {
            time -= (double)hour * 3600.0;
        }
        if ((min = (int)(time / 60.0)) > 0) {
            time -= (double)min * 60.0;
        }
        int second = (int)time;
        int centieme = (int)(100.0 * (time - (double)second) + 0.5);
        return String.valueOf(hour) + ":" + min + ":" + second + "." + centieme;
    }

    public double slope(double[] x, double[] y, int n) {
        if (n < 2) {
            return 0.0;
        }
        double[] x2 = new double[n];
        double[] y2 = new double[n];
        for (int i = 0; i < n; ++i) {
            x2[i] = x[i];
            y2[i] = y[i];
        }
        return LeastSquares.calcCoefficients(x2, y2, 1)[1];
    }
}

