/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.probdist;

import umontreal.ssj.functions.MathFunction;
import umontreal.ssj.functions.MathFunctionUtil;
import umontreal.ssj.probdist.ContinuousDistribution;
import umontreal.ssj.util.Misc;

public class InverseDistFromDensity
extends ContinuousDistribution {
    private final boolean DEBUG = false;
    protected static final double HALF_PI = 1.5707963267948966;
    private final double epsc = 1.0E-5;
    private final double HUGE = 8.988465674311579E307;
    private double epsu0;
    private double xc;
    MathFunction m_dens;
    private String name;
    private final int K0 = 128;
    private int Kmax;
    private double[] A;
    private double[] F;
    private double[][] X;
    private double[][] U;
    private double[][] C;
    private int order;
    private int[] Index;
    private int Imax;
    private double bleft;
    private double bright;
    private double bl;
    private double br;
    private double llc;
    private double rlc;
    private double lc1;
    private double lc2;
    private double lc3;
    private double rc1;
    private double rc2;
    private double rc3;
    private double epstail;
    private boolean lcutF = false;
    private boolean rcutF = false;

    protected void printArray(double[] U) {
        System.out.print("      Tableau = (");
        for (int j = 0; j < U.length; ++j) {
            System.out.printf("  %f", U[j]);
        }
        System.out.println("  )");
    }

    private void init(double xc, double epsu, int n) {
        double[] zs = new double[n + 1];
        double[] ys = new double[n + 1];
        double[] xs = new double[n + 1];
        double[] vs = new double[n + 1];
        double[] us = new double[n + 1];
        double[] cs = new double[n + 1];
        epsu = 0.9 * epsu;
        this.findSupport(xc);
        double I0 = MathFunctionUtil.gaussLobatto(this.m_dens, this.bleft, this.bright, 1.0E-6);
        if (I0 > 1.05 || I0 < 0.95) {
            throw new IllegalStateException("  NOT a probability density");
        }
        this.epstail = 0.05 * epsu * I0;
        this.epstail = Math.min(this.epstail, 1.0E-10);
        double tol = this.epstail = Math.max(this.epstail, 1.0E-15);
        this.findCutoff(this.bleft, this.epstail, false);
        this.findCutoff(this.bright, this.epstail, true);
        this.reserve(0, n);
        this.A[0] = this.bl;
        this.F[0] = this.lcutF ? this.epstail : 0.0;
        ys[0] = 0.0;
        double HMIN = 1.0E-12;
        double h = (this.br - this.bl) / 128.0;
        int k = 0;
        this.calcChebyZ(zs, n);
        double eps = 0.0;
        while (this.A[k] < this.br) {
            while (h >= 1.0E-12) {
                this.calcChebyX(zs, xs, n, h);
                this.calcU(this.m_dens, this.A[k], xs, us, n, tol);
                Misc.interpol(n, us, xs, cs);
                this.NTest(us, vs, n);
                for (int j = 1; j <= n; ++j) {
                    ys[j] = Misc.evalPoly(n, us, cs, vs[j]);
                }
                try {
                    eps = this.calcEps(this.m_dens, this.A[k], ys, vs, n, tol);
                }
                catch (IllegalArgumentException e) {
                    h = 0.5 * h;
                    continue;
                }
                if (eps <= epsu) break;
                h = 0.8 * h;
            }
            if (k + 1 >= this.A.length) {
                this.reserve(k, n);
            }
            this.copy(k, cs, us, xs, n);
            if (this.F[k] > 1.01) {
                throw new IllegalStateException("Unable to compute CDF");
            }
            ++k;
            if (eps < epsu / 3.0) {
                h = 1.3 * h;
            }
            if (h < 1.0E-12) {
                h = 1.0E-12;
            }
            if (!(this.A[k] > this.br)) continue;
            this.A[k] = this.br;
            this.F[k] = 1.0;
        }
        this.Kmax = k;
        while (k > 0 && this.F[k] >= 1.0) {
            this.F[k] = 1.0;
            --k;
        }
        this.reserve(-this.Kmax, n);
        this.createIndex(this.Kmax);
    }

    public InverseDistFromDensity(ContinuousDistribution dist, double xc, double eps, int order) {
        this.setParams(dist, null, xc, eps, order);
        this.init(xc, eps, order);
    }

    public InverseDistFromDensity(MathFunction dens, double xc, double eps, int order, double xleft, double xright) {
        this.supportA = xleft;
        this.supportB = xright;
        this.setParams(null, dens, xc, eps, order);
        this.init(xc, eps, order);
    }

    @Override
    public double density(double x) {
        return this.m_dens.evaluate(x);
    }

    @Override
    public double cdf(double x) {
        throw new UnsupportedOperationException("cdf not implemented");
    }

    @Override
    public double inverseF(double u) {
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (u >= 1.0) {
            return this.supportB;
        }
        if (u <= 0.0) {
            return this.supportA;
        }
        if (u < this.epstail && this.lcutF) {
            return this.uinvLeftTail(u);
        }
        if (u > 1.0 - this.epstail && this.rcutF) {
            return this.uinvRightTail(u);
        }
        int k = this.searchIndex(u);
        double x = this.A[k] + Misc.evalPoly(this.order, this.U[k], this.C[k], u - this.F[k]);
        if (x <= this.supportA) {
            return this.supportA;
        }
        if (x >= this.supportB) {
            return this.supportB;
        }
        return x;
    }

    public double getXc() {
        return this.xc;
    }

    public double getEpsilon() {
        return this.epsu0;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public double[] getParams() {
        double[] retour = new double[]{this.xc, this.epsu0, this.order};
        return retour;
    }

    public String toString() {
        return this.name;
    }

    private void createIndex(int Kmax) {
        this.Imax = 2 * Kmax;
        this.Index = new int[this.Imax + 1];
        this.Index[0] = 0;
        this.Index[this.Imax] = Kmax - 1;
        int k = 1;
        for (int i = 1; i < this.Imax; ++i) {
            double u = (double)i / (double)this.Imax;
            while (u >= this.F[k]) {
                ++k;
            }
            this.Index[i] = k - 1;
        }
    }

    private int searchIndex(double u) {
        int k;
        int i = (int)((double)this.Imax * u);
        for (k = this.Index[i]; u >= this.F[k] && k < this.Kmax; ++k) {
        }
        if (k <= 0) {
            return 0;
        }
        return k - 1;
    }

    private void copy(int k, double[] cs, double[] us, double[] xs, int n) {
        for (int j = 0; j <= n; ++j) {
            this.X[k][j] = xs[j];
            this.C[k][j] = cs[j];
            this.U[k][j] = us[j];
        }
        this.A[k + 1] = this.A[k] + xs[n];
        this.F[k + 1] = this.F[k] + us[n];
    }

    private double calcEps(MathFunction dens, double a, double[] Y, double[] V, int n, double tol) {
        double eps = 0.0;
        double u = 0.0;
        for (int j = 1; j <= n; ++j) {
            double dif = Math.abs((u += MathFunctionUtil.gaussLobatto(dens, a + Y[j - 1], a + Y[j], tol)) - V[j]);
            if (!(dif > eps)) continue;
            eps = dif;
        }
        return eps;
    }

    private void NEval(double[] C, double[] U, double[] T, double[] Y, int n) {
        int j;
        boolean fail = false;
        Y[0] = 0.0;
        for (j = 1; j <= n; ++j) {
            Y[j] = Misc.evalPoly(n, U, C, T[j]);
            if (!(Y[j] < Y[j - 1])) continue;
            fail = true;
        }
        if (fail) {
            for (j = 1; j <= n; ++j) {
                Y[j] = Misc.evalPoly(1, U, C, T[j]);
            }
        }
    }

    private void calcU(MathFunction dens, double a, double[] X, double[] U, int n, double tol) {
        U[0] = 0.0;
        for (int j = 1; j <= n; ++j) {
            U[j] = U[j - 1] + MathFunctionUtil.gaussLobatto(dens, a + X[j - 1], a + X[j], tol);
        }
    }

    private void reserve(int m, int n) {
        this.A = this.reserve(this.A, m);
        this.F = this.reserve(this.F, m);
        this.C = this.reserve(this.C, m, n);
        this.U = this.reserve(this.U, m, n);
        this.X = this.reserve(this.X, m, n);
    }

    private double[] reserve(double[] T, int m) {
        if (m == 0) {
            T = new double[129];
        } else if (m < 0) {
            m = -m;
            double[] tem = new double[m + 1];
            for (int i = 0; i <= m; ++i) {
                tem[i] = T[i];
            }
            T = tem;
        } else {
            double[] tem = new double[2 * m + 1];
            for (int i = 0; i <= m; ++i) {
                tem[i] = T[i];
            }
            T = tem;
        }
        return T;
    }

    private double[][] reserve(double[][] T, int m, int n) {
        if (m == 0) {
            T = new double[129][n + 1];
        } else if (m < 0) {
            m = -m;
            double[][] tem = new double[m + 1][n + 1];
            for (int i = 0; i <= m; ++i) {
                for (int j = 0; j <= n; ++j) {
                    tem[i][j] = T[i][j];
                }
            }
            T = tem;
        } else {
            double[][] tem = new double[2 * m + 1][n + 1];
            for (int i = 0; i <= m; ++i) {
                for (int j = 0; j <= n; ++j) {
                    tem[i][j] = T[i][j];
                }
            }
            T = tem;
        }
        return T;
    }

    private void NTest(double[] U, double[] T, int n) {
        T[0] = 0.0;
        for (int k = 1; k <= n; ++k) {
            T[k] = (U[k - 1] + U[k]) / 2.0;
            for (int j = 0; j < 2; ++j) {
                double tem;
                double s = 0.0;
                double sq = 0.0;
                for (int i = 0; i <= n && (tem = T[k] - U[i]) != 0.0; ++i) {
                    tem = 1.0 / tem;
                    s += tem;
                    sq += tem * tem;
                }
                if (sq == 0.0) continue;
                int n2 = k;
                T[n2] = T[n2] + s / sq;
            }
        }
    }

    private void calcChebyZ(double[] Z, int n) {
        double phi = 1.5707963267948966 / (double)(n + 1);
        double c = Math.cos(phi);
        double temp = 0.0;
        for (int j = 0; j < n; ++j) {
            double y = temp;
            temp = Math.sin((double)(j + 1) * phi);
            Z[j] = (y *= temp) / c;
        }
        Z[n] = 1.0;
    }

    private void calcChebyX(double[] Z, double[] X, int n, double h) {
        for (int j = 1; j < n; ++j) {
            X[j] = h * Z[j];
        }
        X[0] = 0.0;
        X[n] = h;
    }

    private double binSearch(double xa, double xb, double eps, boolean right) {
        double epslow = 0.1 * eps;
        double x = 0.0;
        double y = 0.0;
        boolean fini = false;
        if (right) {
            while (!fini) {
                x = 0.5 * (xa + xb);
                if (xb - xa < eps * Math.abs(x) || xb - xa < eps) {
                    fini = true;
                    if (x > this.supportB) {
                        x = this.supportB;
                    }
                }
                if ((y = this.m_dens.evaluate(x)) < epslow) {
                    xb = x;
                    continue;
                }
                if (y > eps) {
                    xa = x;
                    continue;
                }
                fini = true;
            }
        } else {
            while (!fini) {
                x = 0.5 * (xa + xb);
                if (xb - xa < eps * Math.abs(x) || xb - xa < eps) {
                    fini = true;
                    if (x < this.supportA) {
                        x = this.supportA;
                    }
                }
                if ((y = this.m_dens.evaluate(x)) < epslow) {
                    xa = x;
                    continue;
                }
                if (y > eps) {
                    xb = x;
                    continue;
                }
                fini = true;
            }
        }
        return x;
    }

    private void findSupport(double xc) {
        double xb;
        double xa;
        double h;
        double x;
        double y;
        boolean flagL = false;
        boolean flagR = false;
        double DELTA = 1.0E-100;
        double DELTAR = 1.0E-14;
        double bl = this.supportA;
        double br = this.supportB;
        if (bl > Double.NEGATIVE_INFINITY) {
            y = this.m_dens.evaluate(bl);
            x = bl;
            if (y >= 8.988465674311579E307 || y <= 0.0) {
                x = bl + 1.0E-14 * Math.abs(bl);
                if (x == 0.0) {
                    x = 1.0E-100;
                }
                y = this.m_dens.evaluate(x);
            }
            if (y >= 8.988465674311579E307) {
                throw new UnsupportedOperationException("Infinite density at left boundary");
            }
            if (y >= 1.0E-50) {
                flagL = true;
                bl = x;
            }
        }
        if (br < Double.POSITIVE_INFINITY) {
            y = this.m_dens.evaluate(br);
            x = br;
            if (y >= 8.988465674311579E307 || y <= 0.0) {
                x = br - 1.0E-14 * Math.abs(br);
                if (x == 0.0) {
                    x = -1.0E-100;
                }
                y = this.m_dens.evaluate(x);
            }
            if (y >= 8.988465674311579E307) {
                throw new UnsupportedOperationException("Infinite density at right boundary");
            }
            if (y >= 1.0E-50) {
                flagR = true;
                br = x;
            }
        }
        this.bleft = bl;
        this.bright = br;
        if (flagL && flagR) {
            return;
        }
        y = this.m_dens.evaluate(xc);
        double epsy = 1.0E-13 * y;
        if (!flagR) {
            h = 1.0;
            xa = xc;
            xb = xc + h;
            while (this.m_dens.evaluate(xb) >= epsy) {
                xa = xb;
                xb += (h *= 2.0);
            }
            if (xb > this.supportB) {
                xb = this.supportB;
            }
            this.bright = x = this.binSearch(xa, xb, epsy, true);
        }
        if (!flagL) {
            h = 1.0;
            xb = xc;
            xa = xc - h;
            while (this.m_dens.evaluate(xa) >= epsy) {
                xb = xa;
                xa -= (h *= 2.0);
            }
            if (xa < this.supportA) {
                xa = this.supportA;
            }
            this.bleft = x = this.binSearch(xa, xb, epsy, false);
        }
    }

    protected void setParams(ContinuousDistribution dist, MathFunction dens, double xc, double eps, int order) {
        if (eps < 1.0E-15) {
            throw new IllegalArgumentException("eps < 10^{-15}");
        }
        if (eps > 0.001) {
            throw new IllegalArgumentException("eps > 10^{-3}");
        }
        if (order < 3) {
            throw new IllegalArgumentException("order < 3");
        }
        if (order > 12) {
            throw new IllegalArgumentException("order > 12");
        }
        this.epsu0 = eps;
        this.xc = xc;
        this.order = order;
        StringBuffer sb = new StringBuffer("InverseDistFromDensity: ");
        if (dist == null) {
            this.m_dens = dens;
        } else {
            this.m_dens = new MaDensite(dist);
            sb.append(dist.toString());
        }
        this.name = sb.toString();
    }

    private double uinvLeftTail(double u) {
        double x = 0.0;
        x = this.llc <= 1.0E-5 ? this.bl + this.lc1 * Math.log(u * this.lc2) : this.bl + this.lc1 * (Math.pow(u * this.lc2, this.lc3) - 1.0);
        if (x <= this.supportA) {
            return this.supportA;
        }
        return x;
    }

    private double uinvRightTail(double u) {
        double x = 0.0;
        double v = 1.0 - u;
        x = this.rlc <= 1.0E-5 ? this.br + this.rc1 * Math.log(v * this.rc2) : this.br + this.rc1 * (Math.pow(v * this.rc2, this.rc3) - 1.0);
        if (x >= this.supportB) {
            return this.supportB;
        }
        return x;
    }

    private void findCutoff(double x0, double eps, boolean right) {
        double del;
        double epsx = 0.001;
        double range = this.bright - this.bleft;
        if (right) {
            del = this.m_dens.evaluate(this.bright) - this.m_dens.evaluate(this.bright - 0.001);
            if (this.supportB < Double.POSITIVE_INFINITY && (this.supportB - this.bright <= 0.001 || this.supportB - this.bright <= Math.abs(this.supportB) * 0.001)) {
                this.br = del < 0.0 ? this.supportB : this.bright;
                this.rcutF = false;
                return;
            }
            this.rcutF = true;
        } else {
            del = this.m_dens.evaluate(this.bleft + 0.001) - this.m_dens.evaluate(this.bleft);
            if (this.supportA > Double.NEGATIVE_INFINITY && (this.bleft - this.supportA <= 0.001 || this.bleft - this.supportA <= Math.abs(this.supportA) * 0.001)) {
                this.bl = del > 0.0 ? this.supportA : this.bleft;
                this.lcutF = false;
                return;
            }
            this.lcutF = true;
        }
        double c = 0.0;
        double h = 0.015625;
        h = Math.max(h, (this.bright - this.bleft) / 1024.0);
        double x = x0;
        double y = 0.0;
        double yl = 0.0;
        double yr = 0.0;
        double yprime = 0.0;
        double tem = 0.0;
        int iter = 0;
        int ITERMAX = 30;
        boolean fini = false;
        while (!fini && iter < 30) {
            double xnew;
            ++iter;
            boolean ended = false;
            int it = 0;
            while (!ended && it < 10) {
                ++it;
                if (x + h > this.supportB) {
                    h = this.supportB - x;
                }
                if (x - h < this.supportA) {
                    h = x - this.supportA;
                }
                yr = this.m_dens.evaluate(x + h);
                y = this.m_dens.evaluate(x);
                yl = this.m_dens.evaluate(x - h);
                if (yl != 0.0 && yr != 0.0 && y != 0.0) {
                    ended = true;
                    continue;
                }
                h /= 2.0;
            }
            c = yr / (yr - y) + yl / (yl - y) - 1.0;
            yprime = (yr - yl) / (2.0 * h);
            tem = Math.abs(y * y / ((c + 1.0) * yprime));
            if (Double.isNaN(tem) || Math.abs(tem / eps - 1.0) < 1.0E-4) break;
            if (Math.abs(c) <= 1.0E-5) {
                tem = eps * Math.abs(yprime) / (y * y);
                if (tem <= 0.0) break;
                xnew = x + y / yprime * Math.log(tem);
            } else {
                tem = (1.0 + c) * eps * Math.abs(yprime) / (y * y);
                if (tem < 0.0) break;
                xnew = x + y / (c * yprime) * (Math.pow(tem, c / (1.0 + c)) - 1.0);
            }
            if (Math.abs(xnew - x) <= Math.abs(x) * 0.001 || Math.abs(xnew - x) <= 0.001) {
                fini = true;
            } else {
                x = xnew;
            }
            if (right) {
                this.rlc = Math.abs(c);
                this.br = x;
                this.rc3 = c / (1.0 + c);
                this.rc2 = tem / eps;
                this.rc1 = y / yprime;
                if (Math.abs(c) > 1.0E-5) {
                    this.rc1 /= c;
                }
            } else {
                this.llc = Math.abs(c);
                this.bl = x;
                this.lc3 = c / (1.0 + c);
                this.lc2 = tem / eps;
                this.lc1 = y / yprime;
                if (Math.abs(c) > 1.0E-5) {
                    this.lc1 /= c;
                }
            }
            if (!(Math.abs(xnew - x) >= range)) continue;
            fini = true;
        }
        if (right) {
            if (this.rc1 == 0.0 && this.rc2 == 0.0 && this.rc3 == 0.0) {
                this.br = this.bright;
                this.rcutF = false;
            }
        } else if (this.lc1 == 0.0 && this.lc2 == 0.0 && this.lc3 == 0.0) {
            this.bl = this.bleft;
            this.lcutF = false;
        }
    }

    private class MaDensite
    implements MathFunction {
        private ContinuousDistribution cdist;

        public MaDensite(ContinuousDistribution dist) {
            this.cdist = dist;
            InverseDistFromDensity.this.supportA = this.cdist.getXinf();
            InverseDistFromDensity.this.supportB = this.cdist.getXsup();
        }

        @Override
        public double evaluate(double x) {
            return this.cdist.density(x);
        }
    }
}

