/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.functions.MathFunction;
import umontreal.ssj.probdist.ContinuousDistribution;
import umontreal.ssj.probdist.InverseDistFromDensity;
import umontreal.ssj.randvar.RandomVariateGen;
import umontreal.ssj.rng.RandomStream;

public class InverseFromDensityGen
extends RandomVariateGen {
    public InverseFromDensityGen(RandomStream stream, ContinuousDistribution dis, double xc, double eps, int order) {
        super(stream, null);
        this.dist = new InverseDistFromDensity(dis, xc, eps, order);
    }

    public InverseFromDensityGen(RandomStream stream, MathFunction dens, double xc, double eps, int order, double xleft, double xright) {
        super(stream, null);
        this.dist = new InverseDistFromDensity(dens, xc, eps, order, xleft, xright);
    }

    @Override
    public double nextDouble() {
        return this.dist.inverseF(this.stream.nextDouble());
    }

    public double getXc() {
        return ((InverseDistFromDensity)this.dist).getXc();
    }

    public double getEpsilon() {
        return ((InverseDistFromDensity)this.dist).getEpsilon();
    }

    public int getOrder() {
        return ((InverseDistFromDensity)this.dist).getOrder();
    }
}

