/*
 * Decompiled with CFR 0.152.
 */
package umontreal.ssj.randvar;

import umontreal.ssj.probdist.ContinuousDistribution;
import umontreal.ssj.randvar.RandomVariateGen;
import umontreal.ssj.rng.RandomStream;

abstract class JohnsonSystemG
extends RandomVariateGen {
    protected double gamma;
    protected double delta;
    protected double xi;
    protected double lambda;

    protected JohnsonSystemG(RandomStream s, double gamma, double delta, double xi, double lambda) {
        super(s, null);
        this.setParams(gamma, delta, xi, lambda);
    }

    protected JohnsonSystemG(RandomStream s, ContinuousDistribution dist) {
        super(s, dist);
    }

    public double getGamma() {
        return this.gamma;
    }

    public double getDelta() {
        return this.delta;
    }

    public double getXi() {
        return this.xi;
    }

    public double getLambda() {
        return this.lambda;
    }

    protected void setParams(double gamma, double delta, double xi, double lambda) {
        if (lambda <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (delta <= 0.0) {
            throw new IllegalArgumentException("delta <= 0");
        }
        this.gamma = gamma;
        this.delta = delta;
        this.xi = xi;
        this.lambda = lambda;
    }
}

